###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_java_prdts_detect_win.nasl 1203 2009-04-10 15:24:35Z apr $
#
# Sun Java Products Version Detection (Win)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800383);
  script_version("Revision: 1.0 ");
  script_name(english:"Sun Java Products Version Detection (Win)");
  desc["english"] = "
  Overview : This script finds the installed version of Java Products and
  sets the results in KB.

  Risk factor : Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Set the KB for the version of Java Products");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

# Java Web-Start
wsVer = registry_get_sz(key:"SOFTWARE\JavaSoft\Java Web Start",
                        item:"CurrentVersion");
if(wsVer != NULL){
  set_kb_item(name:"Sun/Java/WebStart/Win/Ver", value:wsVer);
}

# Java Runtime Environment
jreKey = "SOFTWARE\JavaSoft\Java Runtime Environment";
if(registry_key_exists(key:jreKey))
{
  keys = registry_enum_keys(key:jreKey);
  foreach item (keys)
  {
    jreVer = eregmatch(pattern:"([0-9.]\.[0-9]\.[0-9._]+)", string:item);
    if(jreVer[1] != NULL){
      set_kb_item(name:"Sun/Java/JRE/Win/Ver", value:jreVer[1]);
    }
  }
}

# Java Development Kit
jdkKey = "SOFTWARE\JavaSoft\Java Development Kit";
if(registry_key_exists(key:jdkKey))
{
  keys = registry_enum_keys(key:jdkKey);
  foreach item (keys)
  {
    jdkVer = eregmatch(pattern:"([0-9.]\.[0-9]\.[0-9._]+)", string:item);
    if(jdkVer[1] != NULL){
      set_kb_item(name:"Sun/Java/JDK/Win/Ver", value:jdkVer[1]);
    }
  }
}

# JRE for Windows IE
ieJavaKey = registry_get_sz(key:"SOFTWARE\Microsoft\Internet Explorer" +
                                "\AdvancedOptions\JAVA_SUN\SELECT",
                            item:"Text");
if(("Use JRE" || "Use Java") >< ieJavaKey)
{
  ieJavaVer =  ereg_replace(pattern:"Use (JRE.|Java.*v)([._0-9].*) for.*",
                            replace:"\2", string:ieJavaKey);
  if(ieJavaVer){
    set_kb_item(name:"Sun/Java/JRE/Win/IE/Ver", value:ieJavaVer);
  }
}
