###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for DCE HPSBUX02294
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835162);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "02294");
  script_cve_id("CVE-2007-6195");
  script_name(english: "HP-UX Update for DCE HPSBUX02294");
  desc["english"] = "

  Vulnerability Insight:
  A potential security vulnerability has been identified with HP-UX 
  applications running DCE such as Software Distributor (SD). The 
  vulnerability could be exploited remotely to create a denial of service 
  (DoS). 

  Impact:
  Remote Denial of Service (DoS)

  Affected Software/OS:
  DCE on
  HP-UX B.11.11 and B.11.23 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c01294212-1

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of DCE");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"DCE-Core.DCE-CORE-DTS", patch_list:['PHSS_36005'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"DCE-Core.DCE-CORE-RUN", patch_list:['PHSS_36005'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"DCE-Core.DCE-COR-PA-RUN", patch_list:['PHSS_36005'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"DCE-Core.DCE-COR-IA-RUN", patch_list:['PHSS_36005'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"DCE-Core.DCE-COR-64SLIB", patch_list:['PHSS_36005'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"DCE-Core.DCE-CORE-SHLIB", patch_list:['PHSS_36005'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"DCE-Core.DCE-IA64-SHLIB", patch_list:['PHSS_36005'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"DCE-Core.DCEC-ENG-A-MAN", patch_list:['PHSS_36005'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"DCE-CoreTools.DCE-BPRG", patch_list:['PHSS_36005'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"DCE-CoreTools.DCEP-ENG-A-MAN", patch_list:['PHSS_36005'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"DCE-Core.DCEC-ENG-A-MAN", patch_list:['PHSS_36004'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"DCE-Core.DCE-CORE-DTS", patch_list:['PHSS_36004'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"DCE-Core.DCE-CORE-RUN", patch_list:['PHSS_36004'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"DCE-Core.DCE-CORE-SHLIB", patch_list:['PHSS_36004'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"DCE-Core.DCE-COR-64SLIB", patch_list:['PHSS_36004'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}