###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for Software Distributor (SD) HPSBUX00293
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835140);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "00293");
  script_cve_id("");
  script_name(english: "HP-UX Update for Software Distributor (SD) HPSBUX00293");
  desc["english"] = "

  Vulnerability Insight:
  A potential security vulnerability has been identifiedwith HP-UX running 
  Software Distributor (SD), where the SD utilities (swinstall(1M), 
  swverify(1M) and others)may have a locally exploitable buffer overflow that 
  could allow increased privileges. 

  Impact:
  Local increased privileges.

  Affected Software/OS:
  Software Distributor (SD) on
  HP9000 Servers running HP-UX B.11.00, B.11.04 (VVOS) and HP-UX B.11.11 all 
  running Software Distributor (SD). 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c00909785-1

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of Software Distributor (SD)");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.00")
{

  if(ishpuxpkgvuln(pkg:"SW-DIST.SD-CMDS", patch_list:['PHCO_28847'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SW-DIST.SD-AGENT", patch_list:['PHCO_28847'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.04")
{

  if(ishpuxpkgvuln(pkg:"SW-DIST.SD-CMDS", patch_list:['PHCO_30006'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SW-DIST.SD-AGENT", patch_list:['PHCO_30006'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"SW-DIST.SD-CMDS", patch_list:['PHCO_28848'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SW-DIST.SD-AGENT", patch_list:['PHCO_28848'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}