###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ftpshell_server_detect.nasl 926 2009-02-05 12:30:24Z feb $
#
# FTPShell Server Version Detection
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800225);
  script_version("$Revision: 1.0 $");
  script_name(english:"FTPShell Server Version Detection");
  desc["english"] = "
  Overview : This script finds the installed FTPShell Server Version and sets
  the result in KB.

  Risk factor : Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Set Version of FTPShell Server in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"General");
  script_dependencies("find_service.nes", "secpod_reg_enum.nasl");
  script_require_ports("Services/ftp", 21);
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");
include("ftp_func.inc");
include("secpod_smb_func.inc");

ftpPort = get_kb_item("Services/ftp");
if(!ftpPort){
  ftpPort = 21;
}

if(!get_port_state(ftpPort)){
  exit(0);
}

if("FTPshell Server Service" >!< get_ftp_banner(port:ftpPort)){
  exit(0);
}

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item (registry_enum_keys(key:key))
{
  if("FTPShell Server" >< registry_get_sz(key:key + item, item:"DisplayName"))
  {
    ftpVer = registry_get_sz(key:key + item, item:"DisplayVersion");
    if(ftpVer != NULL){
      set_kb_item(name:"FTPShell/Version", value:ftpVer);
    }
    exit(0);
  }
}
