###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_fsecure_prdts_detect_lin.nasl 995 2009-03-12 16:04:29Z mar $
#
# F-Secure Multiple Products Version Detection (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800357);
  script_version("$Revision: 1.0 $");
  script_name(english:"F-Secure Multiple Products Version Detection (Linux)");
  desc["english"] = "
  Overview: The script detects the installed version of F-Seure Anti-Virus,
  Internet security and Internet GateKeeper and sets the version in KB.

  Risk Factor: Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Set the Version of F-Secure Products");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"General");
  exit(0);
}


include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

# Set KB for F-Secure Linux Security and Anti-Virus Linux Client/Server Security
fsavPaths = find_file(file_name:"fsav", file_path:"/", useregex:TRUE,
                 regexpar:"$", sock:sock);

if(fsavPaths != NULL)
{
  foreach fsavBin (fsavPaths)
  {
    fsavVer = get_bin_version(full_prog_name:chomp(fsavBin), sock:sock,
                             version_argv:"--version",
                             ver_pattern:"F-Secure (Anti-Virus )?Linux (Client "+
                                         "|Server )?Security version ([0-9.]+)"+
                                         " build ([0-9]+)([^0-9.]|$)?");
    fsavName = fsavVer;
    if(fsavVer[3] != NULL)
    {
      if(fsavVer[4] != NULL){
         fsavVer = fsavVer[3] + "." + fsavVer[4];
      }
      else{
        fsavVer = fsavVer[3];
      }
      if(fsavName[0] =~ "Linux Security"){
        set_kb_item(name:"F-Sec/AV/LnxSec/Ver", value:fsavVer);
      }
      if(fsavName[0] =~ "Linux Client Security"){
        set_kb_item(name:"F-Sec/AV/LnxClntSec/Ver", value:fsavVer);
      }
      if(fsavName[0] =~ "Linux Server Security"){
        set_kb_item(name:"F-Sec/AV/LnxSerSec/Ver", value:fsavVer);
      }
      break;
    }
  }
}

# Set KB for F-Secure Internet Gatekeeper
fsigkPaths = find_file(file_name:"Makefile", file_path:"/fsigk/", useregex:TRUE,
                       regexpar:"$", sock:sock);
if(fsigkPaths != NULL)
{
  foreach binPath (fsigkPaths)
  {
    fsigkVer = ssh_cmd(socket:sock, timeout:120, cmd:"egrep '^VERSION' " +
                                                     binPath);
    if(fsigkVer != NULL)
    {
      fsigkVer = eregmatch(pattern:"VERSION.*= ([0-9.]+)([^.0-9]|$)",
                           string:fsigkVer);

      if(fsigkVer[1] != NULL)
      {
        buildVer = ssh_cmd(socket:sock, timeout:120,
                           cmd:"egrep '^BUILD_NUMBER' " + binPath);

        buildVer = eregmatch(pattern:"BUILD_NUMBER.*= ([0-9]+)([^.0-9]|$)",
                             string:buildVer);

        if(buildVer[1] != NULL){
          fsigkVer = fsigkVer[1] + "." + buildVer[1];
        }
        else{
          fsigkVer = fsigkVer[1];
        }
        set_kb_item(name:"F-Sec/IntGatekeeper/Lnx/Ver",
                    value:fsigkVer);
      }
      ssh_close_connection();
      exit(0);
    }
  }
}
ssh_close_connection();
