###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ffftp_detect.nasl 837 2009-03-11 10:40:24Z mar $
#
# FFFTP Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800532);
  script_version("Revision: 1.0 ");
  script_name(english:"FFFTP Version Detection");
  desc["english"] = "
  Overview : This script detects the version of FFFTP client and saves the
  result in KB.

  Risk factor : Informational";

  script_description(english:desc["english"]);
  script_family(english:"General");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_summary(english:"Set Version of FFFTP in KB");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

exePath = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                              "\Uninstall\FFFTP", item:"InstallLocation");
if(exePath)
{
  exePath = exePath + "FFFTP.exe";
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:exePath);
  file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:exePath);

  ffftpVer = GetVer(file:file, share:share);
  if(ffftpVer != NULL){
    set_kb_item(name:"FFFTP/Ver", value:ffftpVer);
  }
}
