###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for emacspeak FEDORA-2008-8379
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860373);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-8379");
  script_cve_id("CVE-2008-4191");
  script_name(english: "Fedora Update for emacspeak FEDORA-2008-8379");
  desc["english"] = "

  Vulnerability Insight:
  Emacspeak is a speech interface that allows visually impaired users to
  interact independently and efficiently with the computer. Emacspeak has
  dramatically changed how the author and hundreds of blind and visually
  impaired users around the world interact with the personal computer and
  the Internet. A rich suite of task-oriented speech-enabled tools provides
  efficient speech-enabled access to the evolving semantic WWW.
  When combined with Linux running on low-cost PC hardware,
  Emacspeak/Linux provides a reliable, stable speech-friendly solution that
  opens up the Internet to visually impaired users around the world.


  Affected Software/OS:
  emacspeak on Fedora 9

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-October/msg00010.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of emacspeak");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC9")
{

  if(isrpmvuln(pkg:"emacspeak", rpm:"emacspeak~28.0~3.fc9", rls:"FC9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}