###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_f-prot_av_detect_lin.nasl 794 2009-01-02 12:36:24Z jan $
#	
# F-PROT Antivirus Version Detection (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800324);
  script_version("$Revision: 1.0 $");
  script_name(english:"F-PROT Antivirus Version Detection (Linux)");
  desc["english"] = "
  Overview : The script finds the installed F-PROT Antivirus Version and saves
  the result in KB.

  Risk factor : Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Set Version of F-PROT Antivirus in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"General");
  exit(0);
}


include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

binPaths = find_file(file_name:"fpscan",file_path:"/", useregex:TRUE,
                     regexpar:"$", sock:sock);
foreach fprotBin (binPaths)
{
  fprotVer = get_bin_version(full_prog_name:chomp(fprotBin), sock:sock,
                             version_argv:"--version",
                             ver_pattern:"Antivirus version ([0-9.]+)");
  if(fprotVer[1] != NULL)
  {
    set_kb_item(name:"F-Prot/AV/Linux/Ver", value:fprotVer[1]);
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
