###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_bpsoft_hex_workshop_bof_vuln.nasl 751 2009-03-09 13:08:24Z mar $
#
# BreakPoint Software, Hex Workshop Buffer Overflow vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800528);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0812");
  script_bugtraq_id(33932);
  script_name(english:"BreakPoint Software, Hex Workshop Buffer Overflow vulnerability");
  desc["english"] = "

  Overview: This host has Hex Workshop installed and is prone to Stack
  based Buffer Overflow vulnerability.

  Vulnerability Insight:
  Application fails to adequately sanitize user input data, which in turn
  leads to boundary error while processing of Intel .hex files.

  Impact:
  Successful exploitation could allow remote attacker to execute arbitrary
  code and can cause denial-of-service.

  Impact Level: Application

  Affected Software/OS:
  BreakPoint Software, Hex Workshop version 6.0.1.4603 and prior on Windows.

  Fix: No solution or patch is available as on 09th March, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.bpsoft.com/downloads

  References:
  http://secunia.com/advisories/34021
  http://www.milw0rm.com/exploits/8121

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of Hex Workshop");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Buffer overflow");
  script_dependencies("gb_bpsoft_hex_workshop_detect.nasl");
  script_require_keys("BPSoft/HexWorkshop/Ver");
  exit(0);
}


include("version_func.inc");

hwVer = get_kb_item("BPSoft/HexWorkshop/Ver");
if(!hwVer){
  exit(0);
}

if(version_is_less_equal(version:hwVer, test_version:"6.0.1.4603")){
  security_hole(0);
}
