###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_blazevideo_hdtv_plf_bof_vuln.nasl 1011 2009-02-11 10:44:42Z feb $
#
# Blazevideo HDTV Player PLF File Buffer Overflow Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800513);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0450");
  script_bugtraq_id(33588);
  script_name(english:"Blazevideo HDTV Player PLF File Buffer Overflow Vulnerability");
  desc["english"] = "

  Overview: This host is running Blazevideo HDTV Player and is prone to buffer
  overflow vulnerability.

  Vulnerability Insight:
  Player application fails while handling crafted arbitrary playlist plf files.

  Impact: Successful exploitation will let the attackers execute arbitrary
  codes within the context of the application and can cause heap overflow
  in the application.

  Impact level: Application

  Affected Software/OS:
  Blazevideo HDTV Player 3.5 and prior on all Windows platforms.

  Fix: No solution or patch is available as on 13th February, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.blazevideo.com/hdtv-player/index.htm

  References:
  http://www.milw0rm.com/exploits/7975
  http://www.security-database.com/detail.php?alert=CVE-2009-0450
  http://www.packetstormsecurity.org/filedesc/blazehdtv-hof.txt.html

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor: Critical";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Blazevideo HDTV Player");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Buffer overflow");
  script_dependencies("gb_blazevideo_hdtv_detect.nasl");
  script_require_keys("Blazevideo/HDTV/Ver");
  exit(0);
}


include("version_func.inc");

blazeVer = get_kb_item("Blazevideo/HDTV/Ver");
if(blazeVer == NULL){
  exit(0);
}

#Grep for Blazevideo HDTV Player version 3.5 or prior.
if(version_is_less_equal(version:blazeVer, test_version:"3.5")){
  security_hole(0);
}
