###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for libtiff RHSA-2008:0863-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870048);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0863-01");
  script_cve_id("CVE-2008-2327");
  script_name(english: "RedHat Update for libtiff RHSA-2008:0863-01");
  desc["english"] = "

  Vulnerability Insight:
  The libtiff packages contain a library of functions for manipulating Tagged
  Image File Format (TIFF) files.
  
  Multiple uses of uninitialized values were discovered in libtiff's
  Lempel-Ziv-Welch (LZW) compression algorithm decoder. An attacker could
  create a carefully crafted LZW-encoded TIFF file that would cause an
  application linked with libtiff to crash or, possibly, execute arbitrary
  code. (CVE-2008-2327)
  
  Red Hat would like to thank Drew Yao of the Apple Product Security team for
  reporting this issue.
  
  All libtiff users are advised to upgrade to these updated packages, which
  contain backported patches to resolve this issue.


  Affected Software/OS:
  libtiff on Red Hat Enterprise Linux AS (Advanced Server) version 2.1,
  Red Hat Enterprise Linux ES version 2.1,
  Red Hat Enterprise Linux WS version 2.1,
  Red Hat Enterprise Linux AS version 3,
  Red Hat Enterprise Linux ES version 3,
  Red Hat Enterprise Linux WS version 3

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-August/msg00027.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of libtiff");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_2.1")
{

  if(isrpmvuln(pkg:"libtiff", rpm:"libtiff~3.5.7~31.el2", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libtiff-devel", rpm:"libtiff-devel~3.5.7~31.el2", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "RHENT_3")
{

  if(isrpmvuln(pkg:"libtiff", rpm:"libtiff~3.5.7~31.el3", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libtiff-debuginfo", rpm:"libtiff-debuginfo~3.5.7~31.el3", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libtiff-devel", rpm:"libtiff-devel~3.5.7~31.el3", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}