###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for openldap RHSA-2008:0583-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870172);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0583-01");
  script_cve_id("CVE-2008-2952");
  script_name(english: "RedHat Update for openldap RHSA-2008:0583-01");
  desc["english"] = "

  Vulnerability Insight:
  OpenLDAP is an open source suite of Lightweight Directory Access Protocol
  (LDAP) applications and development tools. LDAP is a set of protocols for
  accessing directory services.
  
  A denial of service flaw was found in the way the OpenLDAP slapd daemon
  processed certain network messages. An unauthenticated remote attacker
  could send a specially crafted request that would crash the slapd daemon.
  (CVE-2008-2952)
  
  Users of openldap should upgrade to these updated packages, which contain a
  backported patch to correct this issue.


  Affected Software/OS:
  openldap on Red Hat Enterprise Linux AS version 4,
  Red Hat Enterprise Linux ES version 4,
  Red Hat Enterprise Linux WS version 4,
  Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-July/msg00009.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of openldap");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"compat-openldap", rpm:"compat-openldap~2.3.27_2.2.29~8.el5_2.4", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openldap", rpm:"openldap~2.3.27~8.el5_2.4", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openldap-clients", rpm:"openldap-clients~2.3.27~8.el5_2.4", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openldap-debuginfo", rpm:"openldap-debuginfo~2.3.27~8.el5_2.4", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openldap-devel", rpm:"openldap-devel~2.3.27~8.el5_2.4", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openldap-servers", rpm:"openldap-servers~2.3.27~8.el5_2.4", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openldap-servers-sql", rpm:"openldap-servers-sql~2.3.27~8.el5_2.4", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "RHENT_4")
{

  if(isrpmvuln(pkg:"compat-openldap", rpm:"compat-openldap~2.1.30~8.el4_6.5", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openldap", rpm:"openldap~2.2.13~8.el4_6.5", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openldap-clients", rpm:"openldap-clients~2.2.13~8.el4_6.5", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openldap-debuginfo", rpm:"openldap-debuginfo~2.2.13~8.el4_6.5", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openldap-devel", rpm:"openldap-devel~2.2.13~8.el4_6.5", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openldap-servers", rpm:"openldap-servers~2.2.13~8.el4_6.5", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openldap-servers-sql", rpm:"openldap-servers-sql~2.2.13~8.el4_6.5", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}