###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for freetype RHSA-2008:0558-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870038);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0558-01");
  script_cve_id("CVE-2008-1806", "CVE-2008-1807", "CVE-2008-1808");
  script_name(english: "RedHat Update for freetype RHSA-2008:0558-01");
  desc["english"] = "

  Vulnerability Insight:
  FreeType is a free, high-quality, portable font engine that can open and
  manage font files, as well as efficiently load, hint and render individual
  glyphs.
  
  Multiple flaws were discovered in FreeType's Printer Font Binary (PFB) and
  TrueType Font (TTF) font-file format parsers. If a user loaded a carefully
  crafted font-file with a program linked against FreeType, it could cause
  the application to crash, or possibly execute arbitrary code.
  (CVE-2008-1806, CVE-2008-1807, CVE-2008-1808)
  
  Note: the flaw in FreeType's TrueType Font (TTF) font-file format parser,
  covered by CVE-2008-1808, only affected the FreeType 1 library (libttf),
  shipped in the freetype packages in Red Hat Enterprise Linux 2.1. The
  FreeType 2 library (libfreetype) is not affected, as it is not compiled
  with TTF Byte Code Interpreter (BCI) support.
  
  Users of freetype should upgrade to these updated packages, which contain
  backported patches to resolve these issues.


  Affected Software/OS:
  freetype on Red Hat Enterprise Linux AS (Advanced Server) version 2.1,
  Red Hat Enterprise Linux ES version 2.1,
  Red Hat Enterprise Linux WS version 2.1

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-June/msg00017.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of freetype");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_2.1")
{

  if(isrpmvuln(pkg:"freetype", rpm:"freetype~2.0.3~13.el21", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freetype-devel", rpm:"freetype-devel~2.0.3~13.el21", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freetype-utils", rpm:"freetype-utils~2.0.3~13.el21", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}