###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for libvorbis RHSA-2008:0271-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870075);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0271-01");
  script_cve_id("CVE-2008-1419", "CVE-2008-1420", "CVE-2008-1423", "CVE-2008-2009");
  script_name(english: "RedHat Update for libvorbis RHSA-2008:0271-01");
  desc["english"] = "

  Vulnerability Insight:
  The libvorbis packages contain runtime libraries for use in programs that
  support Ogg Vorbis. Ogg Vorbis is a fully open, non-proprietary, patent-and
  royalty-free, general-purpose compressed audio format.
  
  Will Drewry of the Google Security Team reported several flaws in the way
  libvorbis processed audio data. An attacker could create a carefully
  crafted OGG audio file in such a way that it could cause an application
  linked with libvorbis to crash, or execute arbitrary code when it was
  opened. (CVE-2008-1419, CVE-2008-1420, CVE-2008-1423, CVE-2008-2009)
  
  Moreover, additional OGG file sanity-checks have been added to prevent
  possible exploitation of similar issues in the future.
  
  Users of libvorbis are advised to upgrade to these updated packages, which
  contain backported patches to resolve these issues.


  Affected Software/OS:
  libvorbis on Red Hat Enterprise Linux AS (Advanced Server) version 2.1,
  Red Hat Enterprise Linux ES version 2.1,
  Red Hat Enterprise Linux WS version 2.1

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-May/msg00008.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of libvorbis");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_2.1")
{

  if(isrpmvuln(pkg:"libvorbis", rpm:"libvorbis~1.0rc2~9.el2", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libvorbis-devel", rpm:"libvorbis-devel~1.0rc2~9.el2", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}