###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for xpdf RHSA-2008:0240-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870090);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0240-01");
  script_cve_id("CVE-2008-1693");
  script_name(english: "RedHat Update for xpdf RHSA-2008:0240-01");
  desc["english"] = "

  Vulnerability Insight:
  Xpdf is an X Window System-based viewer for Portable Document Format (PDF)
  files.
  
  Kees Cook discovered a flaw in the way xpdf displayed malformed fonts
  embedded in PDF files. An attacker could create a malicious PDF file that
  would cause xpdf to crash, or, potentially, execute arbitrary code when
  opened. (CVE-2008-1693)
  
  Users are advised to upgrade to these updated packages, which contain
  backported patches to resolve this issue.


  Affected Software/OS:
  xpdf on Red Hat Enterprise Linux AS version 4,
  Red Hat Enterprise Linux ES version 4,
  Red Hat Enterprise Linux WS version 4

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-April/msg00022.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of xpdf");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_4")
{

  if(isrpmvuln(pkg:"xpdf", rpm:"xpdf~3.00~16.el4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xpdf-debuginfo", rpm:"xpdf-debuginfo~3.00~16.el4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}