###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for ImageMagick RHSA-2008:0145-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870057);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0145-01");
  script_cve_id("CVE-2007-1797", "CVE-2007-4985", "CVE-2007-4986", "CVE-2007-4988", "CVE-2008-1096", "CVE-2008-1097");
  script_name(english: "RedHat Update for ImageMagick RHSA-2008:0145-01");
  desc["english"] = "

  Vulnerability Insight:
  ImageMagick is an image display and manipulation tool for the X Window
  System that can read and write multiple image formats.
  
  Several heap-based buffer overflow flaws were found in ImageMagick. If a
  victim opened a specially crafted DCM or XWD file, an attacker could
  potentially execute arbitrary code on the victim's machine. (CVE-2007-1797)
  
  Several denial of service flaws were found in ImageMagick's parsing of XCF
  and DCM files. Attempting to process a specially-crafted input file in
  these formats could cause ImageMagick to enter an infinite loop.
  (CVE-2007-4985)
  
  Several integer overflow flaws were found in ImageMagick. If a victim
  opened a specially-crafted DCM, DIB, XBM, XCF or XWD file, an attacker
  could potentially execute arbitrary code with the privileges of the user
  running ImageMagick. (CVE-2007-4986)
  
  An integer overflow flaw was found in ImageMagick's DIB parsing code. If a
  victim opened a specially-crafted DIB file, an attacker could potentially
  execute arbitrary code with the privileges of the user running ImageMagick.
  (CVE-2007-4988)
  
  A heap-based buffer overflow flaw was found in the way ImageMagick parsed
  XCF files. If a specially-crafted XCF image was opened, ImageMagick could
  be made to overwrite heap memory beyond the bounds of its allocated memory.
  This could, potentially, allow an attacker to execute arbitrary code on the
  machine running ImageMagick. (CVE-2008-1096)
  
  A heap-based buffer overflow flaw was found in ImageMagick's processing of
  certain malformed PCX images. If a victim opened a specially-crafted PCX
  file, an attacker could possibly execute arbitrary code on the victim's
  machine. (CVE-2008-1097)
  
  All users of ImageMagick should upgrade to these updated packages, which
  contain backported patches to correct these issues.


  Affected Software/OS:
  ImageMagick on Red Hat Enterprise Linux AS version 3,
  Red Hat Enterprise Linux ES version 3,
  Red Hat Enterprise Linux WS version 3,
  Red Hat Enterprise Linux AS version 4,
  Red Hat Enterprise Linux ES version 4,
  Red Hat Enterprise Linux WS version 4,
  Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-April/msg00013.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of ImageMagick");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"ImageMagick", rpm:"ImageMagick~6.2.8.0~4.el5_1.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ImageMagick-c++", rpm:"ImageMagick-c++~6.2.8.0~4.el5_1.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ImageMagick-c++-devel", rpm:"ImageMagick-c++-devel~6.2.8.0~4.el5_1.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ImageMagick-debuginfo", rpm:"ImageMagick-debuginfo~6.2.8.0~4.el5_1.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ImageMagick-devel", rpm:"ImageMagick-devel~6.2.8.0~4.el5_1.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ImageMagick-perl", rpm:"ImageMagick-perl~6.2.8.0~4.el5_1.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "RHENT_4")
{

  if(isrpmvuln(pkg:"ImageMagick", rpm:"ImageMagick~6.0.7.1~17.el4_6.1", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ImageMagick-c++", rpm:"ImageMagick-c++~6.0.7.1~17.el4_6.1", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ImageMagick-c++-devel", rpm:"ImageMagick-c++-devel~6.0.7.1~17.el4_6.1", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ImageMagick-debuginfo", rpm:"ImageMagick-debuginfo~6.0.7.1~17.el4_6.1", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ImageMagick-devel", rpm:"ImageMagick-devel~6.0.7.1~17.el4_6.1", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ImageMagick-perl", rpm:"ImageMagick-perl~6.0.7.1~17.el4_6.1", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "RHENT_3")
{

  if(isrpmvuln(pkg:"ImageMagick", rpm:"ImageMagick~5.5.6~28", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ImageMagick-c++", rpm:"ImageMagick-c++~5.5.6~28", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ImageMagick-c++-devel", rpm:"ImageMagick-c++-devel~5.5.6~28", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ImageMagick-debuginfo", rpm:"ImageMagick-debuginfo~5.5.6~28", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ImageMagick-devel", rpm:"ImageMagick-devel~5.5.6~28", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ImageMagick-perl", rpm:"ImageMagick-perl~5.5.6~28", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}