###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for wireshark RHSA-2008:0059-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870085);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0059-01");
  script_cve_id("CVE-2007-3389", "CVE-2007-3390", "CVE-2007-3391", "CVE-2007-3392", "CVE-2007-3393", "CVE-2007-6113", "CVE-2007-6114", "CVE-2007-6115", "CVE-2007-6117", "CVE-2007-6118", "CVE-2007-6120", "CVE-2007-6121", "CVE-2007-6450", "CVE-2007-6451");
  script_name(english: "RedHat Update for wireshark RHSA-2008:0059-01");
  desc["english"] = "

  Vulnerability Insight:
  Wireshark is a program for monitoring network traffic. Wireshark was
  previously known as Ethereal.
  
  Several flaws were found in Wireshark. Wireshark could crash or possibly
  execute arbitrary code as the user running Wireshark if it read a malformed
  packet off the network. (CVE-2007-6114, CVE-2007-6115, CVE-2007-6117)
  
  Several denial of service bugs were found in Wireshark. Wireshark could
  crash or stop responding if it read a malformed packet off the network.
  (CVE-2007-3389, CVE-2007-3390, CVE-2007-3391, CVE-2007-3392, CVE-2007-3392,
  CVE-2007-3393, CVE-2007-6113, CVE-2007-6118, CVE-2007-6120, CVE-2007-6121,
  CVE-2007-6450, CVE-2007-6451)
  
  As well, Wireshark switched from using net-snmp to libsmi, which is
  included in this errata.
  
  Users of wireshark should upgrade to these updated packages, which contain
  Wireshark version 0.99.7, and resolve these issues.


  Affected Software/OS:
  wireshark on Red Hat Enterprise Linux AS version 3,
  Red Hat Enterprise Linux ES version 3,
  Red Hat Enterprise Linux WS version 3

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-January/msg00015.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of wireshark");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_3")
{

  if(isrpmvuln(pkg:"libsmi", rpm:"libsmi~0.4.5~3.el3", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmi-debuginfo", rpm:"libsmi-debuginfo~0.4.5~3.el3", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmi-devel", rpm:"libsmi-devel~0.4.5~3.el3", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"wireshark", rpm:"wireshark~0.99.7~EL3.1", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"wireshark-debuginfo", rpm:"wireshark-debuginfo~0.99.7~EL3.1", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"wireshark-gnome", rpm:"wireshark-gnome~0.99.7~EL3.1", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}