###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for cairo RHSA-2007:1078-02
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870188);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2007:1078-02");
  script_cve_id("CVE-2007-5503");
  script_name(english: "RedHat Update for cairo RHSA-2007:1078-02");
  desc["english"] = "

  Vulnerability Insight:
  Cairo is a vector graphics library designed to provide high-quality display
  and print output.
  
  An integer overflow flaw was found in the way Cairo processes PNG images.
  If an application linked against Cairo processes a malicious PNG image, it
  is possible to execute arbitrary code as the user running the application.
  (CVE-2007-5503)
  
  Users of Cairo are advised to upgrade to these updated packages, which
  contain a backported patch to resolve this issue.


  Affected Software/OS:
  cairo on Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2007-November/msg00006.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of cairo");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"cairo", rpm:"cairo~1.2.4~3.el5_1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cairo-debuginfo", rpm:"cairo-debuginfo~1.2.4~3.el5_1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cairo-devel", rpm:"cairo-devel~1.2.4~3.el5_1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}