###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for seamonkey CESA-2008:0208-01 centos2 i386
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880000);
  script_version("$Revision: 1.0 $");
  script_xref(name: "CESA", value: "2008:0208-01");
  script_cve_id("CVE-2008-1233", "CVE-2008-1234", "CVE-2008-1235", "CVE-2008-1236", "CVE-2008-1237", "CVE-2008-1238", "CVE-2008-1241");
  script_name(english: "CentOS Update for seamonkey CESA-2008:0208-01 centos2 i386");
  desc["english"] = "

  Vulnerability Insight:
  SeaMonkey is an open source Web browser, advanced email and newsgroup
  client, IRC chat client, and HTML editor.
  
  Several flaws were found in the processing of some malformed web content. A
  web page containing such malicious content could cause SeaMonkey to crash
  or, potentially, execute arbitrary code as the user running SeaMonkey.
  (CVE-2008-1233, CVE-2008-1235, CVE-2008-1236, CVE-2008-1237)
  
  Several flaws were found in the display of malformed web content. A web
  page containing specially-crafted content could, potentially, trick a
  SeaMonkey user into surrendering sensitive information. (CVE-2008-1234,
  CVE-2008-1238, CVE-2008-1241)
  
  All SeaMonkey users should upgrade to these updated packages, which contain
  backported patches to resolve these issues.


  Affected Software/OS:
  seamonkey on CentOS 2

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2008-March/014784.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of seamonkey");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CENTOS2")
{

  if(isrpmvuln(pkg:"seamonkey", rpm:"seamonkey~1.0.9~0.14.el2.c2.1", rls:"CENTOS2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-chat", rpm:"seamonkey-chat~1.0.9~0.14.el2.c2.1", rls:"CENTOS2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-devel", rpm:"seamonkey-devel~1.0.9~0.14.el2.c2.1", rls:"CENTOS2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-dom-inspector", rpm:"seamonkey-dom-inspector~1.0.9~0.14.el2.c2.1", rls:"CENTOS2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-js-debugger", rpm:"seamonkey-js-debugger~1.0.9~0.14.el2.c2.1", rls:"CENTOS2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-mail", rpm:"seamonkey-mail~1.0.9~0.14.el2.c2.1", rls:"CENTOS2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-nspr", rpm:"seamonkey-nspr~1.0.9~0.14.el2.c2.1", rls:"CENTOS2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-nspr-devel", rpm:"seamonkey-nspr-devel~1.0.9~0.14.el2.c2.1", rls:"CENTOS2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-nss", rpm:"seamonkey-nss~1.0.9~0.14.el2.c2.1", rls:"CENTOS2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-nss-devel", rpm:"seamonkey-nss-devel~1.0.9~0.14.el2.c2.1", rls:"CENTOS2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}