###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for unzip CESA-2008:0196-01 centos2 i386
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880011);
  script_version("$Revision: 1.0 $");
  script_xref(name: "CESA", value: "2008:0196-01");
  script_cve_id("CVE-2008-0888");
  script_name(english: "CentOS Update for unzip CESA-2008:0196-01 centos2 i386");
  desc["english"] = "

  Vulnerability Insight:
  The unzip utility is used to list, test, or extract files from a zip
  archive.
  
  An invalid pointer flaw was found in unzip. If a user ran unzip on a
  specially crafted file, an attacker could execute arbitrary code with that
  user's privileges. (CVE-2008-0888)
  
  Red Hat would like to thank Tavis Ormandy of the Google Security Team for
  reporting this issue.
  
  All unzip users are advised to upgrade to these updated packages, which
  contain a backported patch to resolve this issue.


  Affected Software/OS:
  unzip on CentOS 2

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2008-March/014760.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of unzip");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CENTOS2")
{

  if(isrpmvuln(pkg:"unzip", rpm:"unzip~5.50~31.EL2.1", rls:"CENTOS2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}