###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for kernel CESA-2008:0167 centos4 x86_64
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880067);
  script_version("$Revision: 1.0 $");
  script_xref(name: "CESA", value: "2008:0167");
  script_cve_id("CVE-2007-5904");
  script_name(english: "CentOS Update for kernel CESA-2008:0167 centos4 x86_64");
  desc["english"] = "

  Vulnerability Insight:
  The kernel packages contain the Linux kernel, the core of any Linux
  operating system.
  
  A buffer overflow flaw was found in the CIFS virtual file system. A
  remote authenticated user could issue a request that could lead to
  a denial of service. (CVE-2007-5904, Moderate)
  
  As well, these updated packages fix the following bugs:
  
  * a bug was found in the Linux kernel audit subsystem. When the audit
  daemon was setup to log the execve system call with a large number
  of arguments, the kernel could run out out memory while attempting to
  create audit log messages. This could cause a kernel panic. In these
  updated packages, large audit messages are split into acceptable sizes,
  which resolves this issue.
  
  * on certain Intel chipsets, it was not possible to load the acpiphp
  module using the &quot;modprobe acpiphp&quot; command. Because the acpiphp module
  did not recurse across PCI bridges, hardware detection for PCI hot plug
  slots failed. In these updated packages, hardware detection works
  correctly.
  
  * on IBM System z architectures that run the IBM z/VM hypervisor, the IBM
  eServer zSeries HiperSockets network interface (layer 3) allowed ARP
  packets to be sent and received, even when the &quot;NOARP&quot; flag was set. These
  ARP packets caused problems for virtual machines.
  
  * it was possible for the iounmap function to sleep while holding a lock.
  This may have caused a deadlock for drivers and other code that uses the
  iounmap function. In these updated packages, the lock is dropped before
  the sleep code is called, which resolves this issue.
  
  Red Hat Enterprise Linux 4 users are advised to upgrade to these updated
  packages, which contain backported patches to resolve these issues.


  Affected Software/OS:
  kernel on CentOS 4

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2008-March/014753.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of kernel");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CENTOS4")
{

  if(isrpmvuln(pkg:"kernel", rpm:"kernel~2.6.9~67.0.7.EL", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-devel", rpm:"kernel-devel~2.6.9~67.0.7.EL", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-doc", rpm:"kernel-doc~2.6.9~67.0.7.EL", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-largesmp", rpm:"kernel-largesmp~2.6.9~67.0.7.EL", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-largesmp-devel", rpm:"kernel-largesmp-devel~2.6.9~67.0.7.EL", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-smp", rpm:"kernel-smp~2.6.9~67.0.7.EL", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-smp-devel", rpm:"kernel-smp-devel~2.6.9~67.0.7.EL", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xenU", rpm:"kernel-xenU~2.6.9~67.0.7.EL", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xenU-devel", rpm:"kernel-xenU-devel~2.6.9~67.0.7.EL", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}