#
#VID d656296b-33ff-11d9-a9e7-0001020eed82
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52303);
 script_bugtraq_id(11618);
 script_cve_id("CVE-2004-0983");
 script_version ("$");
 name["english"] = "FreeBSD Ports: ruby, ruby_r";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   ruby
   ruby_r
   ruby-1.7.0

CVE-2004-0983
The CGI module in Ruby 1.6 before 1.6.8, and 1.8 before 1.8.2, allows
remote attackers to cause a denial of service (infinite loop and CPU
consumption) via a certain HTTP request.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.debian.org/security/2004/dsa-586
http://www.vuxml.org/freebsd/d656296b-33ff-11d9-a9e7-0001020eed82.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: ruby, ruby_r";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"ruby");
if(!isnull(bver) && revcomp(a:bver, b:"1.7")>0 && revcomp(a:bver, b:"1.8.2.p2_2")<0) {
    security_note(0, data:"Package ruby version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"1.6.8.2004.07.28_1")<0) {
    security_note(0, data:"Package ruby version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"ruby_r");
if(!isnull(bver) && revcomp(a:bver, b:"1.7")>0 && revcomp(a:bver, b:"1.8.2.p2_2")<0) {
    security_note(0, data:"Package ruby_r version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"1.6.8.2004.07.28_1")<0) {
    security_note(0, data:"Package ruby_r version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"ruby-1.7.0");
if(!isnull(bver) && revcomp(a:bver, b:"a2001.05.12")>=0 && revcomp(a:bver, b:"a2001.05.26")<=0) {
    security_note(0, data:"Package ruby-1.7.0 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
