#
#VID 50457509-d05e-11d9-9aed-000e0c2e438a
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(54200);
 script_cve_id("CVE-2005-0869", "CVE-2005-0870");
 script_bugtraq_id(12887);
 script_version ("$");
 name["english"] = "FreeBSD Ports: phpSysInfo";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: phpSysInfo

CVE-2005-0869
phpSysInfo 2.3 allows remote attackers to obtain sensitive information
via a direct request to (1) class.OpenBSD.inc.php, (2)
class.NetBSD.inc.php, (3) class.FreeBSD.inc.php, (4)
class.Darwin.inc.php, (5) XPath.class.php, (6) system_header.php, or
(7) system_footer.php, which reveal the path in a PHP error message.

CVE-2005-0870
Multiple cross-site scripting (XSS) vulnerabilities in phpSysInfo 2.3,
when register_globals is enabled, allow remote attackers to inject
arbitrary web script or HTML via the (1) sensor_program parameter to
index.php, (2) text[language], (3) text[template], or (4)
hide_picklist parameter to system_footer.php.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://marc.theaimsgroup.com/?l=bugtraq&m=111161017209422
http://www.vuxml.org/freebsd/50457509-d05e-11d9-9aed-000e0c2e438a.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: phpSysInfo";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"phpSysInfo");
if(!isnull(bver) && revcomp(a:bver, b:"0")>0) {
    security_note(0, data:"Package phpSysInfo version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
