#
#VID 7c75d48c-429b-11db-afae-000c6ec775d9
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57354);
 script_cve_id("CVE-2006-3311", "CVE-2006-3587", "CVE-2006-3588", "CVE-2006-4640");
 script_version ("$");
 name["english"] = "FreeBSD Ports: linux-flashplugin";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: linux-flashplugin

CVE-2006-3311
** RESERVED **
This candidate has been reserved by an organization or individual that
will use it when announcing a new security problem.  When the
candidate has been publicized, the details for this candidate will be
provided.

CVE-2006-3587
Unspecified vulnerability in Macromedia Flash Player 8.0.24.0 allows
remote attackers to execute arbitrary commands via a malformed .swf
file that results in 'multiple improper memory access' errors.

CVE-2006-3588
Unspecified vulnerability in Macromedia Flash Player 8.0.24.0 allows
remote attackers to cause a denial of service (browser crash) via a
malformed, compressed .swf file.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.adobe.com/support/security/bulletins/apsb06-11.html
http://www.vuxml.org/freebsd/7c75d48c-429b-11db-afae-000c6ec775d9.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: linux-flashplugin";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"linux-flashplugin");
if(!isnull(bver) && revcomp(a:bver, b:"7.0r68")<0) {
    security_note(0, data:"Package linux-flashplugin version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
