#
#VID bb99f803-5fde-11d9-b721-00065be4b5b6
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52245);
 script_cve_id("CVE-2005-0118", "CVE-2005-0119");
 script_version ("$");
 name["english"] = "FreeBSD Ports: ko-helvis";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   ko-helvis
   helvis

CVE-2005-0118
helvis 1.8h2_1 and earlier stores recovery files in world readable
directories with world readable permissions, which allows local users
to read the recovered files of other users.

CVE-2005-0119
helvis 1.8h2_1 and earlier allows local users to recover and read the
files of other users via the elvrec setuid program.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://people.freebsd.org/~niels/ports/korean/helvis/issues.txt
http://www.vuxml.org/freebsd/bb99f803-5fde-11d9-b721-00065be4b5b6.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: ko-helvis";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"ko-helvis");
if(!isnull(bver) && revcomp(a:bver, b:"1.8h2_1")<=0) {
    security_note(0, data:"Package ko-helvis version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"helvis");
if(!isnull(bver) && revcomp(a:bver, b:"1.8h2_1")<=0) {
    security_note(0, data:"Package helvis version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
