#
#VID 396ee517-a607-11d9-ac72-000bdb1444a4
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52145);
 script_bugtraq_id(12943);
 script_cve_id("CVE-2005-0961");
 script_version ("$");
 name["english"] = "FreeBSD Ports: horde, horde-php5";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   horde
   horde-php5

CVE-2005-0961
Cross-site scripting (XSS) vulnerability in Horde 3.0.4 before
3.0.4-RC2 allows remote attackers to inject arbitrary web script or
HTML via the parent frame title.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://cvs.horde.org/diff.php/horde/docs/CHANGES?r1=1.515.2.49&r2=1.515.2.93&ty=h
http://lists.horde.org/archives/announce/2005/000176.html
http://www.vuxml.org/freebsd/396ee517-a607-11d9-ac72-000bdb1444a4.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: horde, horde-php5";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"horde");
if(!isnull(bver) && revcomp(a:bver, b:"3")>0 && revcomp(a:bver, b:"3.0.4")<0) {
    security_note(0, data:"Package horde version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"horde-php5");
if(!isnull(bver) && revcomp(a:bver, b:"3")>0 && revcomp(a:bver, b:"3.0.4")<0) {
    security_note(0, data:"Package horde-php5 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
