#
#VID ad2f3337-26bf-11d9-9289-000c41e2cdad
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52322);
 script_cve_id("CVE-2004-0888", "CVE-2004-0889");
 script_version ("$");
 name["english"] = "FreeBSD Ports: gpdf, cups-base";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   gpdf
   cups-base
   xpdf
   kdegraphics
   koffice
   teTeX-base

CVE-2004-0888
Multiple integer overflows in xpdf 2.0 and 3.0, and other packages
that use xpdf code such as CUPS, gpdf, and kdegraphics, allow remote
attackers to cause a denial of service (crash) and possibly execute
arbitrary code, a different set of vulnerabilities than those
identified by CVE-2004-0889.

CVE-2004-0889
Multiple integer overflows in xpdf 3.0, and other packages that use
xpdf code such as CUPS, allow remote attackers to cause a denial of
service (crash) and possibly execute arbitrary code, a different set
of vulnerabilities than those identified by CVE-2004-0888.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://scary.beasts.org/security/CESA-2004-002.txt
http://scary.beasts.org/security/CESA-2004-007.txt
http://www.kde.org/info/security/advisory-20041021-1.txt
http://www.vuxml.org/freebsd/ad2f3337-26bf-11d9-9289-000c41e2cdad.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: gpdf, cups-base";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"gpdf");
if(!isnull(bver) && revcomp(a:bver, b:"1.1.22.0")<0) {
    security_note(0, data:"Package gpdf version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"cups-base");
if(!isnull(bver) && revcomp(a:bver, b:"1.1.22.0")<0) {
    security_note(0, data:"Package cups-base version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"xpdf");
if(!isnull(bver) && revcomp(a:bver, b:"3.00_4")<0) {
    security_note(0, data:"Package xpdf version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"kdegraphics");
if(!isnull(bver) && revcomp(a:bver, b:"3.3.0_1")<0) {
    security_note(0, data:"Package kdegraphics version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"koffice");
if(!isnull(bver) && revcomp(a:bver, b:"1.3.2_1,1")<0) {
    security_note(0, data:"Package koffice version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"teTeX-base");
if(!isnull(bver) && revcomp(a:bver, b:"2.0.2_4")<0) {
    security_note(0, data:"Package teTeX-base version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
