#
#VID 9f581778-e3d4-11dc-bb89-000bcdc1757a
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(60453);
 script_cve_id("CVE-2008-0504", "CVE-2008-0505", "CVE-2008-0506");
 script_version ("$");
 name["english"] = "FreeBSD Ports: coppermine";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: coppermine

CVE-2008-0504
Multiple SQL injection vulnerabilities in Coppermine Photo Gallery
(CPG) before 1.4.15 allow remote attackers to execute arbitrary SQL
commands via unspecified parameters to (1) util.php and (2)
reviewcom.php.  NOTE: some of these details are obtained from third
party information.

CVE-2008-0505
Multiple cross-site scripting (XSS) vulnerabilities in
docs/showdoc.php in Coppermine Photo Gallery (CPG) before 1.4.15 allow
remote attackers to inject arbitrary web script or HTML via the (1) h
and (2) t parameters.  NOTE: some of these details are obtained from
third party information.

CVE-2008-0506
include/imageObjectIM.class.php in Coppermine Photo Gallery (CPG)
before 1.4.15, when the ImageMagick picture processing method is
configured, allows remote attackers to execute arbitrary commands via
shell metacharacters in the (1) quality, (2) angle, or (3) clipval
parameter to picEditor.php.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://coppermine-gallery.net/forum/index.php?topic=48106.0
http://coppermine-gallery.net/forum/index.php?topic=50103.0
http://secunia.com/advisories/28682/
http://www.vuxml.org/freebsd/9f581778-e3d4-11dc-bb89-000bcdc1757a.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: coppermine";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"coppermine");
if(!isnull(bver) && revcomp(a:bver, b:"1.4.15")<0) {
    security_note(0, data:"Package coppermine version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
