#
#VID f4428842-a583-4a4c-89b7-297c3459a1c3
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52321);
 script_cve_id("CVE-2004-1007");
 script_version ("$");
 name["english"] = "FreeBSD Ports: bogofilter, bogofilter-qdbm, bogofilter-tdb, ru-bogofilter";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   bogofilter
   bogofilter-qdbm
   bogofilter-tdb
   ru-bogofilter

CVE-2004-1007
The quoted-printable decoder in bogofilter 0.17.4 to 0.92.7 allows
remote attackers to cause a denial of service (application crash) via
mail headers that cause a line feed (LF) to be replaced by a null byte
that is written to an incorrect memory address.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://bugs.debian.org/275373
http://bogofilter.sourceforge.net/security/bogofilter-SA-2004-01
http://article.gmane.org/gmane.mail.bogofilter.devel/3308
http://article.gmane.org/gmane.mail.bogofilter.devel/3317
http://www.vuxml.org/freebsd/f4428842-a583-4a4c-89b7-297c3459a1c3.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: bogofilter, bogofilter-qdbm, bogofilter-tdb, ru-bogofilter";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"bogofilter");
if(!isnull(bver) && revcomp(a:bver, b:"0.17.4")>=0 && revcomp(a:bver, b:"0.92.8")<0) {
    security_note(0, data:"Package bogofilter version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"bogofilter-qdbm");
if(!isnull(bver) && revcomp(a:bver, b:"0.17.4")>=0 && revcomp(a:bver, b:"0.92.8")<0) {
    security_note(0, data:"Package bogofilter-qdbm version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"bogofilter-tdb");
if(!isnull(bver) && revcomp(a:bver, b:"0.17.4")>=0 && revcomp(a:bver, b:"0.92.8")<0) {
    security_note(0, data:"Package bogofilter-tdb version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"ru-bogofilter");
if(!isnull(bver) && revcomp(a:bver, b:"0.17.4")>=0 && revcomp(a:bver, b:"0.92.8")<0) {
    security_note(0, data:"Package ru-bogofilter version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
