# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-3753 (cups)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63876);
 script_cve_id("CVE-2009-0163", "CVE-2009-0164", "CVE-2009-0146", "CVE-2009-0147", "CVE-2009-0166", "CVE-2008-5183", "CVE-2008-5286", "CVE-2008-1722", "CVE-2008-3639", "CVE-2008-3640", "CVE-2008-3641", "CVE-2008-1373");
 script_version ("$");
 name["english"] = "Fedora Core 9 FEDORA-2009-3753 (cups)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to cups
announced via advisory FEDORA-2009-3753.

Update Information:

This update fixes several security issues: CVE-2009-0163, CVE-2009-0164,
CVE-2009-0146, CVE-2009-0147, and CVE-2009-0166.

PDF files are now converted to PostScript using the poppler package's
pdftops program.    NOTE: If your CUPS server is accessed using a
hostname or hostnames not known to the server itself you must add
ServerAlias hostname to cupsd.conf for each such name.
The special line ServerAlias * disables checking (but this allows DNS
rebinding attacks).

ChangeLog:

* Tue Apr 21 2009 Tim Waugh  1:1.3.10-1
- 1.3.10.  No longer need ext, includeifexists, str2988,
CVE-2008-5183, CVE-2008-5286, str3077, str3078, str3059, str3055 patches.
- Requires poppler-utils.
- NOTE: If your CUPS server is accessed using a hostname or hostnames
not known to the server itself you must add ServerAlias hostname
for each such name.  The special line ServerAlias * disables checking
(but this allows DNS rebinding attacks).
* Fri Apr 17 2009 Tim Waugh 
- Fixed getnameddest patch (bug #481481, STR #3082).
* Wed Jan 28 2009 Tim Waugh  1:1.3.9-4
- Always supply document-name when printing a file (STR #3055).
- Load MIME type rules correctly (bug #426089, STR #3059).
- Fixed quotas (STR #3077, STR #3078).
- Removed all patch fuzz.

References:

[ 1 ] Bug #490597 - CVE-2009-0164 cups: insufficient checking of the HTTP Host: header
https://bugzilla.redhat.com/show_bug.cgi?id=490597
[ 2 ] Bug #490596 - CVE-2009-0163 cups: Integer overflow in the TIFF image filter
https://bugzilla.redhat.com/show_bug.cgi?id=490596
[ 3 ] Bug #490612 - CVE-2009-0146 xpdf: Multiple buffer overflows in JBIG2 decoder (setBitmap, readSymbolDictSeg)
https://bugzilla.redhat.com/show_bug.cgi?id=490612
[ 4 ] Bug #490614 - CVE-2009-0147 xpdf: Multiple integer overflows in JBIG2 decoder
https://bugzilla.redhat.com/show_bug.cgi?id=490614
[ 5 ] Bug #490625 - CVE-2009-0166 xpdf: Freeing of potentially uninitialized memory in JBIG2 decoder
https://bugzilla.redhat.com/show_bug.cgi?id=490625

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update cups' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-3753

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Fedora Core 9 FEDORA-2009-3753 (cups)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"cups", rpm:"cups~1.3.10~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.3.10~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.3.10~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-lpd", rpm:"cups-lpd~1.3.10~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-debuginfo", rpm:"cups-debuginfo~1.3.10~1.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
