# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 947-2
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56207);
 script_bugtraq_id(16191);
 script_cve_id("CVE-2006-0162");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 947-2 (clamav)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to clamav
announced via advisory DSA 947-2.

A heap overflow has been discovered in ClamAV, a virus scanner, which
could allow an attacker to execute arbitrary code by sending a carefully
crafted UPX-encoded executable to a system runnig ClamAV. In addition,
other potential overflows have been corrected.

Packages for the ARM architecture were not available when DSA 947-1 was
released; these packages are now available. Also, DSA 947-1 incorrectly
identified the package version which corrected these issues in the
unstable distribution (sid).

The old stable distribution (woody) does not include ClamAV.

For the stable distribution (sarge) this problem has been fixed in
version 0.84-2.sarge.7.

For the unstable distribution (sid) this problem has been fixed in
version 0.88-1.

We recommend that you upgrade your clamav package immediately.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20947-2

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 947-2 (clamav)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2006 E-Soft Inc. http://www.securiytspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"clamav", ver:"0.84-2.sarge.7", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-daemon", ver:"0.84-2.sarge.7", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-freshclam", ver:"0.84-2.sarge.7", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-milter", ver:"0.84-2.sarge.7", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libclamav-dev", ver:"0.84-2.sarge.7", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libclamav1", ver:"0.84-2.sarge.7", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
