# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 916-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55971);
 script_cve_id("CVE-2005-3737", "CVE-2005-3885");
 script_bugtraq_id(14522);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 916-1 (inkscape)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to inkscape
announced via advisory DSA 916-1.

Several vulnerabilities have been discovered in Inkscape, a
vector-based drawing program.  The Common Vulnerabilities and
Exposures project identifies the following problems:

CVE-2005-3737

Joxean Koret discovered a buffer overflow in the SVG parsing
routines that can lead to the execution of arbitrary code.

CVE-2005-3885

Javier Fernndez-Sanguino Pea noticed that the ps2epsi extension
shell script uses a hardcoded temporary file making it vulnerable
to symlink attacks.

The old stable distribution (woody) does not contain inkscape packages.

For the stable distribution (sarge) this problem has been fixed in
version 0.41-4.99.sarge2.

For the unstable distribution (sid) this problem has been fixed in
version 0.42.2+0.43pre1-1.

We recommend that you upgrade your inkscape package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20916-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 916-1 (inkscape)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securiytspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"inkscape", ver:"0.41-4.99.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
