# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 846-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55541);
 script_cve_id("CVE-2005-1111", "CVE-2005-1229");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 846-1 (cpio)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to cpio
announced via advisory DSA 846-1.

Two vulnerabilities have been discovered in cpio, a program to manage
archives of files.  The Common Vulnerabilities and Exposures project
identifies the following problems:

CVE-2005-1111
Imran Ghory discovered a race condition in setting the file
permissions of files extracted from cpio archives.  A local
attacker with write access to the target directory could exploit
this to alter the permissions of arbitrary files the extracting
user has write permissions for.

CVE-2005-1229
Imran Ghory discovered that cpio does not sanitise the path of
extracted files even if the --no-absolute-filenames option was
specified.  This can be exploited to install files in arbitrary
locations where the extracting user has write permissions to.

For the old stable distribution (woody) these problems have been fixed in
version 2.4.2-39woody2.

For the stable distribution (sarge) these problems have been fixed in
version 2.5-1.3.

For the unstable distribution (sid) these problems have been fixed in
version 2.6-6.

We recommend that you upgrade your cpio package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20846-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 846-1 (cpio)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"cpio", ver:"2.4.2-39woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cpio", ver:"2.5-1.3", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
