# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 729-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53558);
 script_cve_id("CVE-2005-0525");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 729-1 (php4)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to php4
announced via advisory DSA 729-1.

An iDEFENSE researcher discovered two problems in the image processing
functions of PHP, a server-side, HTML-embedded scripting language, of
which one is present in woody as well.  When reading a JPEG image, PHP
can be tricked into an endless loop due to insufficient input
validation.

For the stable distribution (woody) this problem has been fixed in
version 4.1.2-7.woody4.

For the testing distribution (sarge) these problems have been fixed in
version 4.3.10-10.

For the unstable distribution (sid) these problems have been fixed in
version 4.3.10-10.

We recommend that you upgrade your php4 packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20729-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 729-1 (php4)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"php4-dev", ver:"4.1.2-7.woody4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-pear", ver:"4.1.2-7.woody4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"caudium-php4", ver:"4.1.2-7.woody4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4", ver:"4.1.2-7.woody4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-cgi", ver:"4.1.2-7.woody4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-curl", ver:"4.1.2-7.woody4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-domxml", ver:"4.1.2-7.woody4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-gd", ver:"4.1.2-7.woody4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-imap", ver:"4.1.2-7.woody4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-ldap", ver:"4.1.2-7.woody4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-mcal", ver:"4.1.2-7.woody4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-mhash", ver:"4.1.2-7.woody4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-mysql", ver:"4.1.2-7.woody4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-odbc", ver:"4.1.2-7.woody4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-recode", ver:"4.1.2-7.woody4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-snmp", ver:"4.1.2-7.woody4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-sybase", ver:"4.1.2-7.woody4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-xslt", ver:"4.1.2-7.woody4", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
