# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 594-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53282);
 script_bugtraq_id(11471);
 script_cve_id("CVE-2004-0940");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 594-1 (apache)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to apache
announced via advisory DSA 594-1.

Two vulnerabilities have been identified in the Apache 1.3 webserver:

CVE-2004-0940

Crazy Einstein has discovered a vulnerability in the
mod_include module, which can cause a buffer to be overflown and
could lead to the execution of arbitrary code.

NO VULN ID

Larry Cashdollar has discovered a potential buffer overflow in the
htpasswd utility, which could be exploited when user-supplied is
passed to the program via a CGI (or PHP, or ePerl, ...) program.

For the stable distribution (woody) these problems have been fixed in
version 1.3.26-0woody6.

For the unstable distribution (sid) these problems have been fixed in
version 1.3.33-2.

We recommend that you upgrade your apache packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20594-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 594-1 (apache)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"apache-doc", ver:"1.3.26-0woody6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache", ver:"1.3.26-0woody6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache-common", ver:"1.3.26-0woody6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache-dev", ver:"1.3.26-0woody6", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
