# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 449-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53701);
 script_cve_id("CVE-2004-0104", "CVE-2004-0105");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 449-1 (metamail)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to metamail
announced via advisory DSA 449-1.

Ulf Hrnhammar discovered two format string bugs (CVE-2004-0104) and
two buffer overflow bugs (CVE-2004-0105) in metamail, an
implementation of MIME.  An attacker could create a carefully-crafted
mail message which will execute arbitrary code as the victim when it
is opened and parsed through metamail.

We have been devoting some effort to trying to avoid shipping metamail
in the future.  It became unmaintainable and these are probably not
the last of the vulnerabilities.

For the stable distribution (woody) these problems have been fixed in
version 2.7-45woody.2.

For the unstable distribution (sid) these problems will be fixed in
version 2.7-45.2.

We recommend that you upgrade your metamail package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20449-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 449-1 (metamail)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"metamail", ver:"2.7-45woody.2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
