# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1785-1 (wireshark)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63937);
 script_cve_id("CVE-2009-1210", "CVE-2009-1268", "CVE-2009-1269");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1785-1 (wireshark)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to wireshark
announced via advisory DSA 1785-1.

Several remote vulnerabilities have been discovered in the Wireshark
network traffic analyzer, which may lead to denial of service or the
execution of arbitrary code. The Common Vulnerabilities and Exposures
project identifies the following problems:

CVE-2009-1210

A format string vulnerability was discovered in the PROFINET
dissector.

CVE-2009-1268

The dissector for the Check Point High-Availability Protocol
could be forced to crash.

CVE-2009-1269

Malformed Tektronix files could lead to a crash.

The old stable distribution (etch), is only affected by the
CPHAP crash, which doesn't warrant an update on its own. The fix
will be queued up for an upcoming security update or a point release.

For the stable distribution (lenny), these problems have been fixed in
version 1.0.2-3+lenny5.

For the unstable distribution (sid), these problems have been fixed in
version 1.0.7-1.

We recommend that you upgrade your wireshark packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201785-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1785-1 (wireshark)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"wireshark", ver:"1.0.2-3+lenny5", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wireshark-common", ver:"1.0.2-3+lenny5", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tshark", ver:"1.0.2-3+lenny5", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wireshark-dev", ver:"1.0.2-3+lenny5", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
