# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1733-1 (vim)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63500);
 script_cve_id("CVE-2008-2712", "CVE-2008-3074", "CVE-2008-3075", "CVE-2008-3076", "CVE-2008-4104", "CVE-2008-4101");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1733-1 (vim)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to vim
announced via advisory DSA 1733-1.

Several vulnerabilities have been found in vim, an enhanced vi editor.
The Common Vulnerabilities and Exposures project identifies the
following problems:

CVE-2008-2712

Jan Minar discovered that vim did not properly sanitise inputs
before invoking the execute or system functions inside vim
scripts. This could lead to the execution of arbitrary code.

CVE-2008-3074

Jan Minar discovered that the tar plugin of vim did not properly
sanitise the filenames in the tar archive or the name of the
archive file itself, making it prone to arbitrary code execution.

CVE-2008-3075

Jan Minar discovered that the zip plugin of vim did not properly
sanitise the filenames in the zip archive or the name of the
archive file itself, making it prone to arbitrary code execution.

CVE-2008-3076

Jan Minar discovered that the netrw plugin of vim did not properly
sanitise the filenames or directory names it is given. This could
lead to the execution of arbitrary code.

CVE-2008-4101

Ben Schmidt discovered that vim did not properly escape characters
when performing keyword or tag lookups. This could lead to the
execution of arbitrary code.


For the stable distribution (lenny), these problems have been fixed in
version 1:7.1.314-3+lenny1, which was already included in the lenny
release.

For the oldstable distribution (etch), these problems have been fixed in
version 1:7.0-122+1etch4.

For the testing distribution (squeeze), these problems have been fixed
in version 1:7.1.314-3+lenny1.

For the unstable distribution (sid), these problems have been fixed in
version 2:7.2.010-1.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201733-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1733-1 (vim)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"vim-gui-common", ver:"7.0-122+1etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vim-runtime", ver:"7.0-122+1etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vim-doc", ver:"7.0-122+1etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vim-gnome", ver:"7.0-122+1etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vim-full", ver:"7.0-122+1etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vim", ver:"7.0-122+1etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vim-common", ver:"7.0-122+1etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vim-lesstif", ver:"7.0-122+1etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vim-tcl", ver:"7.0-122+1etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vim-python", ver:"7.0-122+1etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vim-tiny", ver:"7.0-122+1etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vim-gtk", ver:"7.0-122+1etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vim-ruby", ver:"7.0-122+1etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vim-perl", ver:"7.0-122+1etch5", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
