# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1688-2 (courier-authlib)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63063);
 script_cve_id("CVE-2008-2380", "CVE-2008-2667");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1688-2 (courier-authlib)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to courier-authlib
announced via advisory DSA 1688-2.

The update of courier-authlib in DSA 1688-1 caused a regression with
setups that do not use mail addresses for authentification.  This update
fixes this regression. For reference, the full advisory text is below.

Two SQL injection vulnerabilities have beein found in courier-authlib,
the courier authentification library.  The MySQL database interface used
insufficient escaping mechanisms when constructing SQL statements,
leading to SQL injection vulnerabilities if certain charsets are used
(CVE-2008-2380).  A similar issue affects the PostgreSQL database
interface (CVE-2008-2667).

For the stable distribution (etch), these problems have been fixed in
version 0.58-4+etch3.

For the testing distribution (lenny) and the unstable distribution
(sid), these problems have been fixed in version 0.61.0-1+lenny1.

We recommend that you upgrade your courier-authlib packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201688-2

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1688-2 (courier-authlib)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"courier-authlib-dev", ver:"0.58-4+etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-authdaemon", ver:"0.58-4+etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-authlib-pipe", ver:"0.58-4+etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-authlib", ver:"0.58-4+etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-authlib-ldap", ver:"0.58-4+etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-authlib-postgresql", ver:"0.58-4+etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-authlib-mysql", ver:"0.58-4+etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-authlib-userdb", ver:"0.58-4+etch3", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
