# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1684-1 (lcms)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(62954);
 script_cve_id("CVE-2008-5316", "CVE-2008-5317");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1684-1 (lcms)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to lcms
announced via advisory DSA 1684-1.

Two vulnerabilities have been found in lcms, a library and set of
commandline utilities for image color management.  The Common
Vulnerabilities and Exposures project identifies the following
problems:

CVE-2008-5316

Inadequate enforcement of fixed-length buffer limits allows an
attacker to overflow a buffer on the stack, potentially enabling
the execution of arbitrary code when a maliciously-crafted
image is opened.

CVS-2008-5317

An integer sign error in reading image gamma data could allow an
attacker to cause an under-sized buffer to be allocated for
subsequent image data, with unknown consequences potentially
including the execution of arbitrary code if a maliciously-crafted
image is opened.

For the stable distribution (etch), these problems have been fixed in
version 1.14-1.1+etch1.

For the upcoming stable distribution (lenny), and the unstable
distribution (sid), these problems are fixed in version 1.17.dfsg-1.

We recommend that you upgrade your lcms packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201684-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1684-1 (lcms)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"liblcms1-dev", ver:"1.15-1.1+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"liblcms1", ver:"1.15-1.1+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"liblcms-utils", ver:"1.15-1.1+etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
