# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 142-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53404);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 142-1 (openafs)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to openafs
announced via advisory DSA 142-1.

An integer overflow bug has been discovered in the RPC library used by
the OpenAFS database server, which is derived from the SunRPC library.
This bug could be exploited to crash certain OpenAFS servers
(volserver, vlserver, ptserver, buserver) or to obtain unauthorized
root access to a host running one of these processes.  No exploits are
known to exist yet.

This problem has been fixed in version 1.2.3final2-6 for the current
stable distribution (woody) and in version 1.2.6-1 for the unstable
distribution (sid).  Debian 2.2 (potato) is not affected since it
doesn't contain OpenAFS packages.

We recommend that you upgrade your openafs packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20142-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 142-1 (openafs)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"openafs-modules-source", ver:"1.2.3final2-6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libopenafs-dev", ver:"1.2.3final2-6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openafs-client", ver:"1.2.3final2-6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openafs-dbserver", ver:"1.2.3final2-6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openafs-fileserver", ver:"1.2.3final2-6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openafs-kpasswd", ver:"1.2.3final2-6", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
