# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 125-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53578);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 125-1 (analog)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to analog
announced via advisory DSA 125-1.

Yuji Takahashi discovered a bug in analog which allows a cross-site
scripting type attack.  It is easy for an attacker to insert arbitrary
strings into any web server logfile.  If these strings are then
analysed by analog, they can appear in the report.  By this means an
attacker can introduce arbitrary Javascript code, for example, into an
analog report produced by someone else and read by a third person.
Analog already attempted to encode unsafe characters to avoid this
type of attack, but the conversion was incomplete.

This problem has been fixed in the upstream version 5.22 of analog.
Unfortunately patching the old version of analog in the stable
distribution of Debian instead is a very large job that defeats us.

We recommend that you upgrade your analog package immediately.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20125-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 125-1 (analog)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"analog", ver:"5.22-0potato1", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
