# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1085-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56855);
 script_cve_id("CVE-2004-1617", "CAN-2005-3120");
 script_bugtraq_id(11443);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1085-1 (lynx-ssl)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to lynx-ssl
announced via advisory DSA 1085-1.


Several vulnerabilities have been discoverd in lynx, the popular
text-mode WWW browser.  The Common Vulnerabilities and Exposures
Project identifies the following vulnerabilities:

CVE-2004-1617

Michal Zalewski discovered that lynx is not able to grok invalid
HTML including a TEXTAREA tag with a large COLS value and a large
tag name in an element that is not terminated, and loops forever
trying to render the broken HTML.

CAN-2005-3120

Ulf Hrnhammar discovered a buffer overflow that can be remotely
exploited. During the handling of Asian characters when connecting
to an NNTP server lynx can be tricked to write past the boundary
of a buffer which can lead to the execution of arbitrary code.

For the old stable distribution (woody) these problems have been fixed in
version 2.8.5-2.5woody1.

For the stable distribution (sarge) these problems have been fixed in
version 2.8.6-9sarge1.

For the unstable distribution (sid) these problems will be fixed soon.

We recommend that you upgrade your lynx-cur package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201085-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1085-1 (lynx-ssl)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2006 E-Soft Inc. http://www.securiytspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"lynx-cur-wrapper", ver:"2.8.5-2.5woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lynx-cur", ver:"2.8.5-2.5woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lynx-cur-wrapper", ver:"2.8.6-9sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lynx-cur", ver:"2.8.6-9sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
