###############################################################################
# OpenVAS Vulnerability Test
# $Id$
#
# CUPS '_cupsImageReadTIFF()' Integer Overflow Vulnerability
#
# Authors:      
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Michael Meyer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(100150);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0163");
  script_bugtraq_id(34571);
  script_name(english:"CUPS '_cupsImageReadTIFF()' Integer Overflow Vulnerability");
  desc["english"] = "

  Overview: This host is running CUPS (Common UNIX Printing System) Service,
  which is prone to an Integer Overflow Vulnerabilities.

  Successful exploits may allow attackers to execute arbitrary code
  with the privileges of a user running the utilities. Failed exploit
  attempts likely cause denial-of-service conditions.

  Affected Software/OS:
  CUPS versions prior to 1.3.10

  Solution:
  Updates are available. Please see http://www.cups.org/software.php
  for more information.

  References:
   http://www.securityfocus.com/bid/34571
   http://www.cups.org/str.php?L3031

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of CUPS service");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Michael Meyer");
  script_family(english:"Denial of Service");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 631);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

cupsPort = get_http_port(default:631);
if(!cupsPort){
  exit(0);
}

sndReq = http_get(item:string(dir, "/"), port:cupsPort);
recRes = http_send_recv(port:cupsPort, data:sndReq);
if(recRes == NULL){
  exit(0);
}

if("<TITLE>Home - CUPS" >< recRes &&
      egrep(pattern:"^HTTP/.* 200 OK", string:recRes))
{
  version = eregmatch(pattern: "<TITLE>Home - CUPS ([0-9.]+)</TITLE>", string: recRes);
  if(isnull(version[1]))exit(0);

  if(version_is_less(version:version[1], test_version:"1.3.10")) {
    security_hole(cupsPort);
    exit(0);
  }
}

exit(0);
