###############################################################################
# OpenVAS Vulnerability Test
# $Id: TinyWebGallery_34892.nasl 3309 2009-05-10 15:01:14Z mime $
#
# TinyWebGallery '/admin/_include/init.php' Local File Include
# Vulnerability
#
# Authors
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Michael Meyer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100193);
 script_bugtraq_id(34892);
 script_version ("1.0");

 script_name(english:"TinyWebGallery '/admin/_include/init.php' Local File Include Vulnerability");
 desc["english"] = "

 Overview:
  TinyWebGallery is prone to a local file-include vulnerability
  because it fails to properly sanitize user-supplied input.

  An attacker can exploit this vulnerability to view files and execute
  local scripts in the context of the webserver process. This may aid
  in further attacks.

  TinyWebGallery 1.7.6 is vulnerable; other versions may also be
  affected.

 Solution:
  An update is available. Please see http://www.tinywebgallery.com
  for more information.

 See also:
  http://www.securityfocus.com/bid/34892
  http://www.tinywebgallery.com/forum/viewtopic.php?t=1653

 Risk factor : High";

 script_description(english:desc["english"]);
 script_summary(english:"Determine if TinyWebGallery is vulnerable to Local File Include");
 script_category(ACT_GATHER_INFO);
 script_family(english:"Web application abuses");
 script_copyright(english:"This script is Copyright (C) 2009 Michael Meyer");
 script_dependencie("TinyWebGallery_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

if(!version = get_kb_item(string("www/", port, "/TinyWebGallery")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_is_equal(version: vers, test_version: "1.7.6")) {
     security_hole(port:port);
     exit(0);
  }   
}

exit(0);
