###############################################################################
# OpenVAS Vulnerability Test
# $Id: TinyPHPForum_mult_vuln.nasl 2992 2009-04-02 10:09:33Z mime $
#
# TinyPHPForum Multiple Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Michael Meyer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100097);
 script_bugtraq_id(19281,34339);
 script_version("1.0");

 script_name(english:"TinyPHPForum Multiple Vulnerabilities");
 desc["english"] = "
  
 Overview:
  TinyPHPForum is prone to a directory-traversal vulnerability and to
  an authentication-bypass vulnerability because it fails to
  sufficiently sanitize user-supplied input data. A remote attacker
  can exploit this issue to perform administrative functions without
  requiring authentication or obtain sensitive information that could
  aid in further attacks.

  TinyPHPForum 3.6 and 3.6.1 are vulnerable;

 See also:
  http://www.securityfocus.com/bid/19281
  http://www.securityfocus.com/bid/34339

 Risk factor : Medium";

 script_description(english:desc["english"]);
 script_summary(english:"Determines if TinyPHPForum is <=3.6.1");
 script_category(ACT_GATHER_INFO);
 script_family(english:"Web application abuses");
 script_copyright(english:"This script is Copyright (C) 2009 Michael Meyer");
 script_dependencie("TinyPHPForum_detect.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}


include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!port){
  exit(0);
}

if(VER = get_kb_item(string("www/", port, "/TinyPHPForum"))) {
  matches = eregmatch(string:VER, pattern:"^(.+) under (/.*)$");
  if(!isnull(matches)) {
    VER = matches[1];
    if(version_is_less_equal(version:Ver, test_version:"3.6.1")) {
       security_warning(port:port);
       exit(0);
    }   
  }
}

exit(0);
