# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:1036 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63979);
 script_cve_id("CVE-2009-1574", "CVE-2009-1632");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:1036";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory RHSA-2009:1036.

The ipsec-tools package is used in conjunction with the IPsec functionality
in the Linux kernel and includes racoon, an IKEv1 keying daemon.

A denial of service flaw was found in the ipsec-tools racoon daemon. An
unauthenticated, remote attacker could trigger a NULL pointer dereference
that could cause the racoon daemon to crash. (CVE-2009-1574)

Multiple memory leak flaws were found in the ipsec-tools racoon daemon. If
a remote attacker is able to make multiple connection attempts to the
racoon daemon, it was possible to cause the racoon daemon to consume all
available memory. (CVE-2009-1632)

Users of ipsec-tools should upgrade to this updated package, which contains
backported patches to correct these issues. Users must restart the racoon
daemon for this update to take effect.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-1036.html
http://www.redhat.com/security/updates/classification/#important

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:1036";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"ipsec-tools", rpm:"ipsec-tools~0.6.5~13.el5_3.1", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ipsec-tools-debuginfo", rpm:"ipsec-tools-debuginfo~0.6.5~13.el5_3.1", rls:"RHENT_5")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
