# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:0476 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63949);
 script_cve_id("CVE-2009-1194");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:0476";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory RHSA-2009:0476.

Pango is a library used for the layout and rendering of internationalized
text.

Will Drewry discovered an integer overflow flaw in Pango's
pango_glyph_string_set_size() function. If an attacker is able to pass an
arbitrarily long string to Pango, it may be possible to execute arbitrary
code with the permissions of the application calling Pango. (CVE-2009-1194)

pango and evolution28-pango users are advised to upgrade to these updated
packages, which contain a backported patch to resolve this issue. After
installing this update, you must restart your system or restart the X
server for the update to take effect. Note: Restarting the X server closes
all open applications and logs you out of your session.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-0476.html
http://www.redhat.com/security/updates/classification/#important

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:0476";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"pango", rpm:"pango~1.2.5~8", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pango-debuginfo", rpm:"pango-debuginfo~1.2.5~8", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pango-devel", rpm:"pango-devel~1.2.5~8", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"evolution28-pango", rpm:"evolution28-pango~1.14.9~11.el4_7", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"evolution28-pango-debuginfo", rpm:"evolution28-pango-debuginfo~1.14.9~11.el4_7", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"evolution28-pango-devel", rpm:"evolution28-pango-devel~1.14.9~11.el4_7", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pango", rpm:"pango~1.6.0~14.4_7", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pango-debuginfo", rpm:"pango-debuginfo~1.6.0~14.4_7", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pango-devel", rpm:"pango-devel~1.6.0~14.4_7", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pango", rpm:"pango~1.14.9~5.el5_3", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pango-debuginfo", rpm:"pango-debuginfo~1.14.9~5.el5_3", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pango-devel", rpm:"pango-devel~1.14.9~5.el5_3", rls:"RHENT_5")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
