# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:0350 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63763);
 script_cve_id("CVE-2008-3658", "CVE-2008-3660", "CVE-2008-5498", "CVE-2008-5557", "CVE-2008-5658", "CVE-2008-5814", "CVE-2009-0754", "CVE-2009-1271");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:0350";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory RHSA-2009:0350.

PHP is an HTML-embedded scripting language commonly used with the Apache
HTTP Web server.

A heap-based buffer overflow flaw was found in PHP's mbstring extension. A
remote attacker able to pass arbitrary input to a PHP script using mbstring
conversion functions could cause the PHP interpreter to crash or, possibly,
execute arbitrary code. (CVE-2008-5557)

A flaw was found in the handling of the mbstring.func_overload
configuration setting. A value set for one virtual host, or in a user's
.htaccess file, was incorrectly applied to other virtual hosts on the same
server, causing the handling of multibyte character strings to not work
correctly. (CVE-2009-0754)

A directory traversal flaw was found in PHP's ZipArchive::extractTo
function. If PHP is used to extract a malicious ZIP archive, it could allow
an attacker to write arbitrary files anywhere the PHP process has write
permissions. (CVE-2008-5658)

A buffer overflow flaw was found in PHP's imageloadfont function. If a PHP
script allowed a remote attacker to load a carefully crafted font file, it
could cause the PHP interpreter to crash or, possibly, execute arbitrary
code. (CVE-2008-3658)

A flaw was found in the way PHP handled certain file extensions when
running in FastCGI mode. If the PHP interpreter was being executed via
FastCGI, a remote attacker could create a request which would cause the PHP
interpreter to crash. (CVE-2008-3660)

A memory disclosure flaw was found in the PHP gd extension's imagerotate
function. A remote attacker able to pass arbitrary values as the
background color argument of the function could, possibly, view portions
of the PHP interpreter's memory. (CVE-2008-5498)

A cross-site scripting flaw was found in a way PHP reported errors for
invalid cookies. If the PHP interpreter had display_errors enabled, a
remote attacker able to set a specially-crafted cookie on a victim's system
could possibly inject arbitrary HTML into an error message generated by
PHP. (CVE-2008-5814)

A flaw was found in PHP's json_decode function. A remote attacker could use
this flaw to create a specially-crafted string which could cause the PHP
interpreter to crash while being decoded in a PHP script. (CVE-2009-1271)

All php users are advised to upgrade to these updated packages, which
contain backported patches to resolve these issues. The httpd web server
must be restarted for the changes to take effect.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-0350.html
http://www.redhat.com/security/updates/classification/#moderate

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:0350";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"php", rpm:"php~5.2.6~4.el5s2", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-bcmath", rpm:"php-bcmath~5.2.6~4.el5s2", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-cli", rpm:"php-cli~5.2.6~4.el5s2", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-common", rpm:"php-common~5.2.6~4.el5s2", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-dba", rpm:"php-dba~5.2.6~4.el5s2", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-debuginfo", rpm:"php-debuginfo~5.2.6~4.el5s2", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-devel", rpm:"php-devel~5.2.6~4.el5s2", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-gd", rpm:"php-gd~5.2.6~4.el5s2", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-imap", rpm:"php-imap~5.2.6~4.el5s2", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-ldap", rpm:"php-ldap~5.2.6~4.el5s2", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-mbstring", rpm:"php-mbstring~5.2.6~4.el5s2", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-mysql", rpm:"php-mysql~5.2.6~4.el5s2", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-ncurses", rpm:"php-ncurses~5.2.6~4.el5s2", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-odbc", rpm:"php-odbc~5.2.6~4.el5s2", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-pdo", rpm:"php-pdo~5.2.6~4.el5s2", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-pgsql", rpm:"php-pgsql~5.2.6~4.el5s2", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-snmp", rpm:"php-snmp~5.2.6~4.el5s2", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-soap", rpm:"php-soap~5.2.6~4.el5s2", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-xml", rpm:"php-xml~5.2.6~4.el5s2", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-xmlrpc", rpm:"php-xmlrpc~5.2.6~4.el5s2", rls:"RHENT_5")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
