/*
  File autogenerated by gengetopt version 2.22.6
  generated with the following command:
  /usr/bin/gengetopt --include-getopt --file-name=npa-tool-cmdline --output-dir=. 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif


#include "npa-tool-cmdline.h"

const char *gengetopt_args_info_purpose = "";

const char *gengetopt_args_info_usage = "Usage: npa-tool [OPTIONS]...";

const char *gengetopt_args_info_versiontext = "";

const char *gengetopt_args_info_description = "";

const char *gengetopt_args_info_help[] = {
  "  -h, --help                    Print help and exit",
  "  -V, --version                 Print version and exit",
  "  -r, --reader=INT              Number of the PC/SC reader to use (-1 for\n                                  autodetect)  (default=`-1')",
  "  -v, --verbose                 Use (several times) to be more verbose",
  "\nPassword Authenticated Connection Establishment (PACE):",
  "  -p, --pin[=STRING]            Run PACE with (transport) eID-PIN",
  "  -u, --puk[=STRING]            Run PACE with PUK",
  "  -c, --can[=STRING]            Run PACE with CAN",
  "  -m, --mrz[=STRING]            Run PACE with MRZ (insert MRZ without newlines)",
  "      --env                     Whether to use environment variables PIN, PUK,\n                                  CAN, MRZ and NEWPIN. You may want to clean\n                                  your environment before enabling this.\n                                  (default=off)",
  "\nPIN management:",
  "  -N, --new-pin[=STRING]        Install a new PIN",
  "  -R, --resume                  Resume eID-PIN (uses CAN to activate last\n                                  retry)  (default=off)",
  "  -U, --unblock                 Unblock PIN (uses PUK to activate three more\n                                  retries)  (default=off)",
  "\nTerminal Authentication (TA) and Chip Authentication (CA):",
  "  -C, --cv-certificate=FILENAME Card Verifiable Certificate to create a\n                                  certificate chain. Can be used multiple times\n                                  (order is important).",
  "      --cert-desc=HEX_STRING    Certificate description to show for Terminal\n                                  Authentication",
  "      --chat=HEX_STRING         Card holder authorization template to use\n                                  (default is terminal's CHAT). Use\n                                  7F4C0E060904007F000703010203530103 to trigger\n                                  EAC on the CAT-C (Komfortleser).",
  "  -A, --auxiliary-data=HEX_STRING\n                                Terminal's auxiliary data (default is\n                                  determined by verification of validity, age\n                                  and community ID).",
  "  -P, --private-key=FILENAME    Terminal's private key",
  "      --cvc-dir=DIRECTORY       Where to look for the CVCA's certificate\n                                  (default=`/home/fm/.local/etc/eac/cvc')",
  "      --x509-dir=DIRECTORY      Where to look for the CSCA's certificate\n                                  (default=`/home/fm/.local/etc/eac/x509')",
  "      --disable-ta-checks       Disable checking the validity period of CV\n                                  certifcates  (default=off)",
  "      --disable-ca-checks       Disable passive authentication  (default=off)",
  "\nRead and write data groups:",
  "      --read-dg1                Read DG 1   (Document Type)  (default=off)",
  "      --read-dg2                Read DG 2   (Issuing State)  (default=off)",
  "      --read-dg3                Read DG 3   (Date of Expiry)  (default=off)",
  "      --read-dg4                Read DG 4   (Given Names)  (default=off)",
  "      --read-dg5                Read DG 5   (Family Names)  (default=off)",
  "      --read-dg6                Read DG 6   (Religious/Artistic Name)\n                                  (default=off)",
  "      --read-dg7                Read DG 7   (Academic Title)  (default=off)",
  "      --read-dg8                Read DG 8   (Date of Birth)  (default=off)",
  "      --read-dg9                Read DG 9   (Place of Birth)  (default=off)",
  "      --read-dg10               Read DG 10  (Nationality)  (default=off)",
  "      --read-dg11               Read DG 11  (Sex)  (default=off)",
  "      --read-dg12               Read DG 12  (Optional Data)  (default=off)",
  "      --read-dg13               Read DG 13  (Birth Name)  (default=off)",
  "      --read-dg14               Read DG 14  (default=off)",
  "      --read-dg15               Read DG 15  (default=off)",
  "      --read-dg16               Read DG 16  (default=off)",
  "      --read-dg17               Read DG 17  (Normal Place of Residence)\n                                  (default=off)",
  "      --read-dg18               Read DG 18  (Community ID)  (default=off)",
  "      --read-dg19               Read DG 19  (Residence Permit I)  (default=off)",
  "      --read-dg20               Read DG 20  (Residence Permit II)\n                                  (default=off)",
  "      --read-dg21               Read DG 21  (Optional Data)  (default=off)",
  "      --write-dg17=HEX_STRING   Write DG 17 (Normal Place of Residence)",
  "      --write-dg18=HEX_STRING   Write DG 18 (Community ID)",
  "      --write-dg19=HEX_STRING   Write DG 19 (Residence Permit I)",
  "      --write-dg20=HEX_STRING   Write DG 20 (Residence Permit II)",
  "      --write-dg21=HEX_STRING   Write DG 21 (Optional Data)",
  "\nVerification of validity, age and community ID:",
  "      --verify-validity=YYYYMMDD\n                                Verify chip's validity with a reference date",
  "      --older-than=YYYYMMDD     Verify age with a reference date",
  "      --verify-community=HEX_STRING\n                                Verify community ID with a reference ID",
  "\nSpecial options, not always useful:",
  "  -b, --break                   Brute force PIN, CAN or PUK. Use together with\n                                  -p, -a or -u  (default=off)",
  "  -t, --translate=FILENAME      File with APDUs of HEX_STRINGs to send through\n                                  the secure channel  (default=`stdin')",
  "      --tr-03110v201            Force compliance to BSI TR-03110 version 2.01\n                                  (default=off)",
  "      --disable-all-checks      Disable all checking of fly-by-data\n                                  (default=off)",
  "\nReport bugs to opensc-devel@lists.sourceforge.net\n\nWritten by Frank Morgner <frankmorgner@gmail.com>",
    0
};

typedef enum {ARG_NO
  , ARG_FLAG
  , ARG_STRING
  , ARG_INT
} cmdline_parser_arg_type;

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error);

static int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error);

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->reader_given = 0 ;
  args_info->verbose_given = 0 ;
  args_info->pin_given = 0 ;
  args_info->puk_given = 0 ;
  args_info->can_given = 0 ;
  args_info->mrz_given = 0 ;
  args_info->env_given = 0 ;
  args_info->new_pin_given = 0 ;
  args_info->resume_given = 0 ;
  args_info->unblock_given = 0 ;
  args_info->cv_certificate_given = 0 ;
  args_info->cert_desc_given = 0 ;
  args_info->chat_given = 0 ;
  args_info->auxiliary_data_given = 0 ;
  args_info->private_key_given = 0 ;
  args_info->cvc_dir_given = 0 ;
  args_info->x509_dir_given = 0 ;
  args_info->disable_ta_checks_given = 0 ;
  args_info->disable_ca_checks_given = 0 ;
  args_info->read_dg1_given = 0 ;
  args_info->read_dg2_given = 0 ;
  args_info->read_dg3_given = 0 ;
  args_info->read_dg4_given = 0 ;
  args_info->read_dg5_given = 0 ;
  args_info->read_dg6_given = 0 ;
  args_info->read_dg7_given = 0 ;
  args_info->read_dg8_given = 0 ;
  args_info->read_dg9_given = 0 ;
  args_info->read_dg10_given = 0 ;
  args_info->read_dg11_given = 0 ;
  args_info->read_dg12_given = 0 ;
  args_info->read_dg13_given = 0 ;
  args_info->read_dg14_given = 0 ;
  args_info->read_dg15_given = 0 ;
  args_info->read_dg16_given = 0 ;
  args_info->read_dg17_given = 0 ;
  args_info->read_dg18_given = 0 ;
  args_info->read_dg19_given = 0 ;
  args_info->read_dg20_given = 0 ;
  args_info->read_dg21_given = 0 ;
  args_info->write_dg17_given = 0 ;
  args_info->write_dg18_given = 0 ;
  args_info->write_dg19_given = 0 ;
  args_info->write_dg20_given = 0 ;
  args_info->write_dg21_given = 0 ;
  args_info->verify_validity_given = 0 ;
  args_info->older_than_given = 0 ;
  args_info->verify_community_given = 0 ;
  args_info->break_given = 0 ;
  args_info->translate_given = 0 ;
  args_info->tr_03110v201_given = 0 ;
  args_info->disable_all_checks_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  FIX_UNUSED (args_info);
  args_info->reader_arg = -1;
  args_info->reader_orig = NULL;
  args_info->pin_arg = NULL;
  args_info->pin_orig = NULL;
  args_info->puk_arg = NULL;
  args_info->puk_orig = NULL;
  args_info->can_arg = NULL;
  args_info->can_orig = NULL;
  args_info->mrz_arg = NULL;
  args_info->mrz_orig = NULL;
  args_info->env_flag = 0;
  args_info->new_pin_arg = NULL;
  args_info->new_pin_orig = NULL;
  args_info->resume_flag = 0;
  args_info->unblock_flag = 0;
  args_info->cv_certificate_arg = NULL;
  args_info->cv_certificate_orig = NULL;
  args_info->cert_desc_arg = NULL;
  args_info->cert_desc_orig = NULL;
  args_info->chat_arg = NULL;
  args_info->chat_orig = NULL;
  args_info->auxiliary_data_arg = NULL;
  args_info->auxiliary_data_orig = NULL;
  args_info->private_key_arg = NULL;
  args_info->private_key_orig = NULL;
  args_info->cvc_dir_arg = gengetopt_strdup ("/home/fm/.local/etc/eac/cvc");
  args_info->cvc_dir_orig = NULL;
  args_info->x509_dir_arg = gengetopt_strdup ("/home/fm/.local/etc/eac/x509");
  args_info->x509_dir_orig = NULL;
  args_info->disable_ta_checks_flag = 0;
  args_info->disable_ca_checks_flag = 0;
  args_info->read_dg1_flag = 0;
  args_info->read_dg2_flag = 0;
  args_info->read_dg3_flag = 0;
  args_info->read_dg4_flag = 0;
  args_info->read_dg5_flag = 0;
  args_info->read_dg6_flag = 0;
  args_info->read_dg7_flag = 0;
  args_info->read_dg8_flag = 0;
  args_info->read_dg9_flag = 0;
  args_info->read_dg10_flag = 0;
  args_info->read_dg11_flag = 0;
  args_info->read_dg12_flag = 0;
  args_info->read_dg13_flag = 0;
  args_info->read_dg14_flag = 0;
  args_info->read_dg15_flag = 0;
  args_info->read_dg16_flag = 0;
  args_info->read_dg17_flag = 0;
  args_info->read_dg18_flag = 0;
  args_info->read_dg19_flag = 0;
  args_info->read_dg20_flag = 0;
  args_info->read_dg21_flag = 0;
  args_info->write_dg17_arg = NULL;
  args_info->write_dg17_orig = NULL;
  args_info->write_dg18_arg = NULL;
  args_info->write_dg18_orig = NULL;
  args_info->write_dg19_arg = NULL;
  args_info->write_dg19_orig = NULL;
  args_info->write_dg20_arg = NULL;
  args_info->write_dg20_orig = NULL;
  args_info->write_dg21_arg = NULL;
  args_info->write_dg21_orig = NULL;
  args_info->verify_validity_arg = NULL;
  args_info->verify_validity_orig = NULL;
  args_info->older_than_arg = NULL;
  args_info->older_than_orig = NULL;
  args_info->verify_community_arg = NULL;
  args_info->verify_community_orig = NULL;
  args_info->break_flag = 0;
  args_info->translate_arg = gengetopt_strdup ("stdin");
  args_info->translate_orig = NULL;
  args_info->tr_03110v201_flag = 0;
  args_info->disable_all_checks_flag = 0;
  
}

static
void init_args_info(struct gengetopt_args_info *args_info)
{


  args_info->help_help = gengetopt_args_info_help[0] ;
  args_info->version_help = gengetopt_args_info_help[1] ;
  args_info->reader_help = gengetopt_args_info_help[2] ;
  args_info->verbose_help = gengetopt_args_info_help[3] ;
  args_info->verbose_min = 0;
  args_info->verbose_max = 0;
  args_info->pin_help = gengetopt_args_info_help[5] ;
  args_info->puk_help = gengetopt_args_info_help[6] ;
  args_info->can_help = gengetopt_args_info_help[7] ;
  args_info->mrz_help = gengetopt_args_info_help[8] ;
  args_info->env_help = gengetopt_args_info_help[9] ;
  args_info->new_pin_help = gengetopt_args_info_help[11] ;
  args_info->resume_help = gengetopt_args_info_help[12] ;
  args_info->unblock_help = gengetopt_args_info_help[13] ;
  args_info->cv_certificate_help = gengetopt_args_info_help[15] ;
  args_info->cv_certificate_min = 0;
  args_info->cv_certificate_max = 0;
  args_info->cert_desc_help = gengetopt_args_info_help[16] ;
  args_info->chat_help = gengetopt_args_info_help[17] ;
  args_info->auxiliary_data_help = gengetopt_args_info_help[18] ;
  args_info->private_key_help = gengetopt_args_info_help[19] ;
  args_info->cvc_dir_help = gengetopt_args_info_help[20] ;
  args_info->x509_dir_help = gengetopt_args_info_help[21] ;
  args_info->disable_ta_checks_help = gengetopt_args_info_help[22] ;
  args_info->disable_ca_checks_help = gengetopt_args_info_help[23] ;
  args_info->read_dg1_help = gengetopt_args_info_help[25] ;
  args_info->read_dg2_help = gengetopt_args_info_help[26] ;
  args_info->read_dg3_help = gengetopt_args_info_help[27] ;
  args_info->read_dg4_help = gengetopt_args_info_help[28] ;
  args_info->read_dg5_help = gengetopt_args_info_help[29] ;
  args_info->read_dg6_help = gengetopt_args_info_help[30] ;
  args_info->read_dg7_help = gengetopt_args_info_help[31] ;
  args_info->read_dg8_help = gengetopt_args_info_help[32] ;
  args_info->read_dg9_help = gengetopt_args_info_help[33] ;
  args_info->read_dg10_help = gengetopt_args_info_help[34] ;
  args_info->read_dg11_help = gengetopt_args_info_help[35] ;
  args_info->read_dg12_help = gengetopt_args_info_help[36] ;
  args_info->read_dg13_help = gengetopt_args_info_help[37] ;
  args_info->read_dg14_help = gengetopt_args_info_help[38] ;
  args_info->read_dg15_help = gengetopt_args_info_help[39] ;
  args_info->read_dg16_help = gengetopt_args_info_help[40] ;
  args_info->read_dg17_help = gengetopt_args_info_help[41] ;
  args_info->read_dg18_help = gengetopt_args_info_help[42] ;
  args_info->read_dg19_help = gengetopt_args_info_help[43] ;
  args_info->read_dg20_help = gengetopt_args_info_help[44] ;
  args_info->read_dg21_help = gengetopt_args_info_help[45] ;
  args_info->write_dg17_help = gengetopt_args_info_help[46] ;
  args_info->write_dg18_help = gengetopt_args_info_help[47] ;
  args_info->write_dg19_help = gengetopt_args_info_help[48] ;
  args_info->write_dg20_help = gengetopt_args_info_help[49] ;
  args_info->write_dg21_help = gengetopt_args_info_help[50] ;
  args_info->verify_validity_help = gengetopt_args_info_help[52] ;
  args_info->older_than_help = gengetopt_args_info_help[53] ;
  args_info->verify_community_help = gengetopt_args_info_help[54] ;
  args_info->break_help = gengetopt_args_info_help[56] ;
  args_info->translate_help = gengetopt_args_info_help[57] ;
  args_info->tr_03110v201_help = gengetopt_args_info_help[58] ;
  args_info->disable_all_checks_help = gengetopt_args_info_help[59] ;
  
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n",
     (strlen(CMDLINE_PARSER_PACKAGE_NAME) ? CMDLINE_PARSER_PACKAGE_NAME : CMDLINE_PARSER_PACKAGE),
     CMDLINE_PARSER_VERSION);

  if (strlen(gengetopt_args_info_versiontext) > 0)
    printf("\n%s\n", gengetopt_args_info_versiontext);
}

static void print_help_common(void) {
  cmdline_parser_print_version ();

  if (strlen(gengetopt_args_info_purpose) > 0)
    printf("\n%s\n", gengetopt_args_info_purpose);

  if (strlen(gengetopt_args_info_usage) > 0)
    printf("\n%s\n", gengetopt_args_info_usage);

  printf("\n");

  if (strlen(gengetopt_args_info_description) > 0)
    printf("%s\n\n", gengetopt_args_info_description);
}

void
cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_help[i])
    printf("%s\n", gengetopt_args_info_help[i++]);
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);
}

void
cmdline_parser_params_init(struct cmdline_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct cmdline_parser_params *
cmdline_parser_params_create(void)
{
  struct cmdline_parser_params *params = 
    (struct cmdline_parser_params *)malloc(sizeof(struct cmdline_parser_params));
  cmdline_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}

/** @brief generic value variable */
union generic_value {
    int int_arg;
    char *string_arg;
    const char *default_string_arg;
};

/** @brief holds temporary values for multiple options */
struct generic_list
{
  union generic_value arg;
  char *orig;
  struct generic_list *next;
};

/**
 * @brief add a node at the head of the list 
 */
static void add_node(struct generic_list **list) {
  struct generic_list *new_node = (struct generic_list *) malloc (sizeof (struct generic_list));
  new_node->next = *list;
  *list = new_node;
  new_node->arg.string_arg = 0;
  new_node->orig = 0;
}


static void
free_multiple_string_field(unsigned int len, char ***arg, char ***orig)
{
  unsigned int i;
  if (*arg) {
    for (i = 0; i < len; ++i)
      {
        free_string_field(&((*arg)[i]));
        free_string_field(&((*orig)[i]));
      }
    free_string_field(&((*arg)[0])); /* free default string */

    free (*arg);
    *arg = 0;
    free (*orig);
    *orig = 0;
  }
}

static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{

  free_string_field (&(args_info->reader_orig));
  free_string_field (&(args_info->pin_arg));
  free_string_field (&(args_info->pin_orig));
  free_string_field (&(args_info->puk_arg));
  free_string_field (&(args_info->puk_orig));
  free_string_field (&(args_info->can_arg));
  free_string_field (&(args_info->can_orig));
  free_string_field (&(args_info->mrz_arg));
  free_string_field (&(args_info->mrz_orig));
  free_string_field (&(args_info->new_pin_arg));
  free_string_field (&(args_info->new_pin_orig));
  free_multiple_string_field (args_info->cv_certificate_given, &(args_info->cv_certificate_arg), &(args_info->cv_certificate_orig));
  free_string_field (&(args_info->cert_desc_arg));
  free_string_field (&(args_info->cert_desc_orig));
  free_string_field (&(args_info->chat_arg));
  free_string_field (&(args_info->chat_orig));
  free_string_field (&(args_info->auxiliary_data_arg));
  free_string_field (&(args_info->auxiliary_data_orig));
  free_string_field (&(args_info->private_key_arg));
  free_string_field (&(args_info->private_key_orig));
  free_string_field (&(args_info->cvc_dir_arg));
  free_string_field (&(args_info->cvc_dir_orig));
  free_string_field (&(args_info->x509_dir_arg));
  free_string_field (&(args_info->x509_dir_orig));
  free_string_field (&(args_info->write_dg17_arg));
  free_string_field (&(args_info->write_dg17_orig));
  free_string_field (&(args_info->write_dg18_arg));
  free_string_field (&(args_info->write_dg18_orig));
  free_string_field (&(args_info->write_dg19_arg));
  free_string_field (&(args_info->write_dg19_orig));
  free_string_field (&(args_info->write_dg20_arg));
  free_string_field (&(args_info->write_dg20_orig));
  free_string_field (&(args_info->write_dg21_arg));
  free_string_field (&(args_info->write_dg21_orig));
  free_string_field (&(args_info->verify_validity_arg));
  free_string_field (&(args_info->verify_validity_orig));
  free_string_field (&(args_info->older_than_arg));
  free_string_field (&(args_info->older_than_orig));
  free_string_field (&(args_info->verify_community_arg));
  free_string_field (&(args_info->verify_community_orig));
  free_string_field (&(args_info->translate_arg));
  free_string_field (&(args_info->translate_orig));
  
  

  clear_given (args_info);
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  FIX_UNUSED (values);
  if (arg) {
    fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}

static void
write_multiple_into_file(FILE *outfile, int len, const char *opt, char **arg, const char *values[])
{
  int i;
  
  for (i = 0; i < len; ++i)
    write_into_file(outfile, opt, (arg ? arg[i] : 0), values);
}

int
cmdline_parser_dump(FILE *outfile, struct gengetopt_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->reader_given)
    write_into_file(outfile, "reader", args_info->reader_orig, 0);
  write_multiple_into_file(outfile, args_info->verbose_given, "verbose", 0, 0);
  if (args_info->pin_given)
    write_into_file(outfile, "pin", args_info->pin_orig, 0);
  if (args_info->puk_given)
    write_into_file(outfile, "puk", args_info->puk_orig, 0);
  if (args_info->can_given)
    write_into_file(outfile, "can", args_info->can_orig, 0);
  if (args_info->mrz_given)
    write_into_file(outfile, "mrz", args_info->mrz_orig, 0);
  if (args_info->env_given)
    write_into_file(outfile, "env", 0, 0 );
  if (args_info->new_pin_given)
    write_into_file(outfile, "new-pin", args_info->new_pin_orig, 0);
  if (args_info->resume_given)
    write_into_file(outfile, "resume", 0, 0 );
  if (args_info->unblock_given)
    write_into_file(outfile, "unblock", 0, 0 );
  write_multiple_into_file(outfile, args_info->cv_certificate_given, "cv-certificate", args_info->cv_certificate_orig, 0);
  if (args_info->cert_desc_given)
    write_into_file(outfile, "cert-desc", args_info->cert_desc_orig, 0);
  if (args_info->chat_given)
    write_into_file(outfile, "chat", args_info->chat_orig, 0);
  if (args_info->auxiliary_data_given)
    write_into_file(outfile, "auxiliary-data", args_info->auxiliary_data_orig, 0);
  if (args_info->private_key_given)
    write_into_file(outfile, "private-key", args_info->private_key_orig, 0);
  if (args_info->cvc_dir_given)
    write_into_file(outfile, "cvc-dir", args_info->cvc_dir_orig, 0);
  if (args_info->x509_dir_given)
    write_into_file(outfile, "x509-dir", args_info->x509_dir_orig, 0);
  if (args_info->disable_ta_checks_given)
    write_into_file(outfile, "disable-ta-checks", 0, 0 );
  if (args_info->disable_ca_checks_given)
    write_into_file(outfile, "disable-ca-checks", 0, 0 );
  if (args_info->read_dg1_given)
    write_into_file(outfile, "read-dg1", 0, 0 );
  if (args_info->read_dg2_given)
    write_into_file(outfile, "read-dg2", 0, 0 );
  if (args_info->read_dg3_given)
    write_into_file(outfile, "read-dg3", 0, 0 );
  if (args_info->read_dg4_given)
    write_into_file(outfile, "read-dg4", 0, 0 );
  if (args_info->read_dg5_given)
    write_into_file(outfile, "read-dg5", 0, 0 );
  if (args_info->read_dg6_given)
    write_into_file(outfile, "read-dg6", 0, 0 );
  if (args_info->read_dg7_given)
    write_into_file(outfile, "read-dg7", 0, 0 );
  if (args_info->read_dg8_given)
    write_into_file(outfile, "read-dg8", 0, 0 );
  if (args_info->read_dg9_given)
    write_into_file(outfile, "read-dg9", 0, 0 );
  if (args_info->read_dg10_given)
    write_into_file(outfile, "read-dg10", 0, 0 );
  if (args_info->read_dg11_given)
    write_into_file(outfile, "read-dg11", 0, 0 );
  if (args_info->read_dg12_given)
    write_into_file(outfile, "read-dg12", 0, 0 );
  if (args_info->read_dg13_given)
    write_into_file(outfile, "read-dg13", 0, 0 );
  if (args_info->read_dg14_given)
    write_into_file(outfile, "read-dg14", 0, 0 );
  if (args_info->read_dg15_given)
    write_into_file(outfile, "read-dg15", 0, 0 );
  if (args_info->read_dg16_given)
    write_into_file(outfile, "read-dg16", 0, 0 );
  if (args_info->read_dg17_given)
    write_into_file(outfile, "read-dg17", 0, 0 );
  if (args_info->read_dg18_given)
    write_into_file(outfile, "read-dg18", 0, 0 );
  if (args_info->read_dg19_given)
    write_into_file(outfile, "read-dg19", 0, 0 );
  if (args_info->read_dg20_given)
    write_into_file(outfile, "read-dg20", 0, 0 );
  if (args_info->read_dg21_given)
    write_into_file(outfile, "read-dg21", 0, 0 );
  if (args_info->write_dg17_given)
    write_into_file(outfile, "write-dg17", args_info->write_dg17_orig, 0);
  if (args_info->write_dg18_given)
    write_into_file(outfile, "write-dg18", args_info->write_dg18_orig, 0);
  if (args_info->write_dg19_given)
    write_into_file(outfile, "write-dg19", args_info->write_dg19_orig, 0);
  if (args_info->write_dg20_given)
    write_into_file(outfile, "write-dg20", args_info->write_dg20_orig, 0);
  if (args_info->write_dg21_given)
    write_into_file(outfile, "write-dg21", args_info->write_dg21_orig, 0);
  if (args_info->verify_validity_given)
    write_into_file(outfile, "verify-validity", args_info->verify_validity_orig, 0);
  if (args_info->older_than_given)
    write_into_file(outfile, "older-than", args_info->older_than_orig, 0);
  if (args_info->verify_community_given)
    write_into_file(outfile, "verify-community", args_info->verify_community_orig, 0);
  if (args_info->break_given)
    write_into_file(outfile, "break", 0, 0 );
  if (args_info->translate_given)
    write_into_file(outfile, "translate", args_info->translate_orig, 0);
  if (args_info->tr_03110v201_given)
    write_into_file(outfile, "tr-03110v201", 0, 0 );
  if (args_info->disable_all_checks_given)
    write_into_file(outfile, "disable-all-checks", 0, 0 );
  

  i = EXIT_SUCCESS;
  return i;
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

static char *
get_multiple_arg_token(const char *arg)
{
  const char *tok;
  char *ret;
  size_t len, num_of_escape, i, j;

  if (!arg)
    return 0;

  tok = strchr (arg, ',');
  num_of_escape = 0;

  /* make sure it is not escaped */
  while (tok)
    {
      if (*(tok-1) == '\\')
        {
          /* find the next one */
          tok = strchr (tok+1, ',');
          ++num_of_escape;
        }
      else
        break;
    }

  if (tok)
    len = (size_t)(tok - arg + 1);
  else
    len = strlen (arg) + 1;

  len -= num_of_escape;

  ret = (char *) malloc (len);

  i = 0;
  j = 0;
  while (arg[i] && (j < len-1))
    {
      if (arg[i] == '\\' && 
	  arg[ i + 1 ] && 
	  arg[ i + 1 ] == ',')
        ++i;

      ret[j++] = arg[i++];
    }

  ret[len-1] = '\0';

  return ret;
}

static const char *
get_multiple_arg_token_next(const char *arg)
{
  const char *tok;

  if (!arg)
    return 0;

  tok = strchr (arg, ',');

  /* make sure it is not escaped */
  while (tok)
    {
      if (*(tok-1) == '\\')
        {
          /* find the next one */
          tok = strchr (tok+1, ',');
        }
      else
        break;
    }

  if (! tok || strlen(tok) == 1)
    return 0;

  return tok+1;
}

static int
check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, unsigned int min, unsigned int max, const char *option_desc);

int
check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, unsigned int min, unsigned int max, const char *option_desc)
{
  int error_occurred = 0;

  if (option_given && (min > 0 || max > 0))
    {
      if (min > 0 && max > 0)
        {
          if (min == max)
            {
              /* specific occurrences */
              if (option_given != (unsigned int) min)
                {
                  fprintf (stderr, "%s: %s option occurrences must be %d\n",
                    prog_name, option_desc, min);
                  error_occurred = 1;
                }
            }
          else if (option_given < (unsigned int) min
                || option_given > (unsigned int) max)
            {
              /* range occurrences */
              fprintf (stderr, "%s: %s option occurrences must be between %d and %d\n",
                prog_name, option_desc, min, max);
              error_occurred = 1;
            }
        }
      else if (min > 0)
        {
          /* at least check */
          if (option_given < min)
            {
              fprintf (stderr, "%s: %s option occurrences must be at least %d\n",
                prog_name, option_desc, min);
              error_occurred = 1;
            }
        }
      else if (max > 0)
        {
          /* at most check */
          if (option_given > max)
            {
              fprintf (stderr, "%s: %s option occurrences must be at most %d\n",
                prog_name, option_desc, max);
              error_occurred = 1;
            }
        }
    }
    
  return error_occurred;
}
int
cmdline_parser (int argc, char **argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser_ext (int argc, char **argv, struct gengetopt_args_info *args_info,
                   struct cmdline_parser_params *params)
{
  int result;
  result = cmdline_parser_internal (argc, argv, args_info, params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser2 (int argc, char **argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = cmdline_parser_internal (argc, argv, args_info, &params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  int result = EXIT_SUCCESS;

  if (cmdline_parser_required2(args_info, prog_name, 0) > 0)
    result = EXIT_FAILURE;

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error)
{
  int error_occurred = 0;
  FIX_UNUSED (additional_error);

  /* checks for required options */
  if (check_multiple_option_occurrences(prog_name, args_info->verbose_given, args_info->verbose_min, args_info->verbose_max, "'--verbose' ('-v')"))
     error_occurred = 1;
  
  if (check_multiple_option_occurrences(prog_name, args_info->cv_certificate_given, args_info->cv_certificate_min, args_info->cv_certificate_max, "'--cv-certificate' ('-C')"))
     error_occurred = 1;
  
  
  /* checks for dependences among options */

  return error_occurred;
}

/*
 * Extracted from the glibc source tree, version 2.3.6
 *
 * Licensed under the GPL as per the whole glibc source tree.
 *
 * This file was modified so that getopt_long can be called
 * many times without risking previous memory to be spoiled.
 *
 * Modified by Andre Noll and Lorenzo Bettini for use in
 * GNU gengetopt generated files.
 *
 */

/* 
 * we must include anything we need since this file is not thought to be
 * inserted in a file already using getopt.h
 *
 * Lorenzo
 */

struct option
{
  const char *name;
  /* has_arg can't be an enum because some compilers complain about
     type mismatches in all the code that assumes it is an int.  */
  int has_arg;
  int *flag;
  int val;
};

/* This version of `getopt' appears to the caller like standard Unix `getopt'
   but it behaves differently for the user, since it allows the user
   to intersperse the options with the other arguments.

   As `getopt' works, it permutes the elements of ARGV so that,
   when it is done, all the options precede everything else.  Thus
   all application programs are extended to handle flexible argument order.
*/
/*
   If the field `flag' is not NULL, it points to a variable that is set
   to the value given in the field `val' when the option is found, but
   left unchanged if the option is not found.

   To have a long-named option do something other than set an `int' to
   a compiled-in constant, such as set a value from `custom_optarg', set the
   option's `flag' field to zero and its `val' field to a nonzero
   value (the equivalent single-letter option character, if there is
   one).  For long options that have a zero `flag' field, `getopt'
   returns the contents of the `val' field.  */

/* Names for the values of the `has_arg' field of `struct option'.  */
#ifndef no_argument
#define no_argument		0
#endif

#ifndef required_argument
#define required_argument	1
#endif

#ifndef optional_argument
#define optional_argument	2
#endif

struct custom_getopt_data {
	/*
	 * These have exactly the same meaning as the corresponding global variables,
	 * except that they are used for the reentrant versions of getopt.
	 */
	int custom_optind;
	int custom_opterr;
	int custom_optopt;
	char *custom_optarg;

	/* True if the internal members have been initialized.  */
	int initialized;

	/*
	 * The next char to be scanned in the option-element in which the last option
	 * character we returned was found.  This allows us to pick up the scan where
	 * we left off.  If this is zero, or a null string, it means resume the scan by
	 * advancing to the next ARGV-element.
	 */
	char *nextchar;

	/*
	 * Describe the part of ARGV that contains non-options that have been skipped.
	 * `first_nonopt' is the index in ARGV of the first of them; `last_nonopt' is
	 * the index after the last of them.
	 */
	int first_nonopt;
	int last_nonopt;
};

/*
 * the variables optarg, optind, opterr and optopt are renamed with
 * the custom_ prefix so that they don't interfere with getopt ones.
 *
 * Moreover they're static so they are visible only from within the
 * file where this very file will be included.
 */

/*
 * For communication from `custom_getopt' to the caller.  When `custom_getopt' finds an
 * option that takes an argument, the argument value is returned here.
 */
static char *custom_optarg;

/*
 * Index in ARGV of the next element to be scanned.  This is used for
 * communication to and from the caller and for communication between
 * successive calls to `custom_getopt'.
 *
 * On entry to `custom_getopt', 1 means this is the first call; initialize.
 *
 * When `custom_getopt' returns -1, this is the index of the first of the non-option
 * elements that the caller should itself scan.
 *
 * Otherwise, `custom_optind' communicates from one call to the next how much of ARGV
 * has been scanned so far.
 *
 * 1003.2 says this must be 1 before any call.
 */
static int custom_optind = 1;

/*
 * Callers store zero here to inhibit the error message for unrecognized
 * options.
 */
static int custom_opterr = 1;

/*
 * Set to an option character which was unrecognized.  This must be initialized
 * on some systems to avoid linking in the system's own getopt implementation.
 */
static int custom_optopt = '?';

/*
 * Exchange two adjacent subsequences of ARGV.  One subsequence is elements
 * [first_nonopt,last_nonopt) which contains all the non-options that have been
 * skipped so far.  The other is elements [last_nonopt,custom_optind), which contains
 * all the options processed since those non-options were skipped.
 * `first_nonopt' and `last_nonopt' are relocated so that they describe the new
 * indices of the non-options in ARGV after they are moved.
 */
static void exchange(char **argv, struct custom_getopt_data *d)
{
	int bottom = d->first_nonopt;
	int middle = d->last_nonopt;
	int top = d->custom_optind;
	char *tem;

	/*
	 * Exchange the shorter segment with the far end of the longer segment.
	 * That puts the shorter segment into the right place.  It leaves the
	 * longer segment in the right place overall, but it consists of two
	 * parts that need to be swapped next.
	 */
	while (top > middle && middle > bottom) {
		if (top - middle > middle - bottom) {
			/* Bottom segment is the short one.  */
			int len = middle - bottom;
			int i;

			/* Swap it with the top part of the top segment.  */
			for (i = 0; i < len; i++) {
				tem = argv[bottom + i];
				argv[bottom + i] =
					argv[top - (middle - bottom) + i];
				argv[top - (middle - bottom) + i] = tem;
			}
			/* Exclude the moved bottom segment from further swapping.  */
			top -= len;
		} else {
			/* Top segment is the short one.  */
			int len = top - middle;
			int i;

			/* Swap it with the bottom part of the bottom segment.  */
			for (i = 0; i < len; i++) {
				tem = argv[bottom + i];
				argv[bottom + i] = argv[middle + i];
				argv[middle + i] = tem;
			}
			/* Exclude the moved top segment from further swapping.  */
			bottom += len;
		}
	}
	/* Update records for the slots the non-options now occupy.  */
	d->first_nonopt += (d->custom_optind - d->last_nonopt);
	d->last_nonopt = d->custom_optind;
}

/* Initialize the internal data when the first call is made.  */
static void custom_getopt_initialize(struct custom_getopt_data *d)
{
	/*
	 * Start processing options with ARGV-element 1 (since ARGV-element 0
	 * is the program name); the sequence of previously skipped non-option
	 * ARGV-elements is empty.
	 */
	d->first_nonopt = d->last_nonopt = d->custom_optind;
	d->nextchar = NULL;
	d->initialized = 1;
}

#define NONOPTION_P (argv[d->custom_optind][0] != '-' || argv[d->custom_optind][1] == '\0')

/* return: zero: continue, nonzero: return given value to user */
static int shuffle_argv(int argc, char *const *argv,const struct option *longopts,
	struct custom_getopt_data *d)
{
	/*
	 * Give FIRST_NONOPT & LAST_NONOPT rational values if CUSTOM_OPTIND has been
	 * moved back by the user (who may also have changed the arguments).
	 */
	if (d->last_nonopt > d->custom_optind)
		d->last_nonopt = d->custom_optind;
	if (d->first_nonopt > d->custom_optind)
		d->first_nonopt = d->custom_optind;
	/*
	 * If we have just processed some options following some
	 * non-options, exchange them so that the options come first.
	 */
	if (d->first_nonopt != d->last_nonopt &&
			d->last_nonopt != d->custom_optind)
		exchange((char **) argv, d);
	else if (d->last_nonopt != d->custom_optind)
		d->first_nonopt = d->custom_optind;
	/*
	 * Skip any additional non-options and extend the range of
	 * non-options previously skipped.
	 */
	while (d->custom_optind < argc && NONOPTION_P)
		d->custom_optind++;
	d->last_nonopt = d->custom_optind;
	/*
	 * The special ARGV-element `--' means premature end of options.  Skip
	 * it like a null option, then exchange with previous non-options as if
	 * it were an option, then skip everything else like a non-option.
	 */
	if (d->custom_optind != argc && !strcmp(argv[d->custom_optind], "--")) {
		d->custom_optind++;
		if (d->first_nonopt != d->last_nonopt
				&& d->last_nonopt != d->custom_optind)
			exchange((char **) argv, d);
		else if (d->first_nonopt == d->last_nonopt)
			d->first_nonopt = d->custom_optind;
		d->last_nonopt = argc;
		d->custom_optind = argc;
	}
	/*
	 * If we have done all the ARGV-elements, stop the scan and back over
	 * any non-options that we skipped and permuted.
	 */
	if (d->custom_optind == argc) {
		/*
		 * Set the next-arg-index to point at the non-options that we
		 * previously skipped, so the caller will digest them.
		 */
		if (d->first_nonopt != d->last_nonopt)
			d->custom_optind = d->first_nonopt;
		return -1;
	}
	/*
	 * If we have come to a non-option and did not permute it, either stop
	 * the scan or describe it to the caller and pass it by.
	 */
	if (NONOPTION_P) {
		d->custom_optarg = argv[d->custom_optind++];
		return 1;
	}
	/*
	 * We have found another option-ARGV-element. Skip the initial
	 * punctuation.
	 */
	d->nextchar = (argv[d->custom_optind] + 1 + (longopts != NULL && argv[d->custom_optind][1] == '-'));
	return 0;
}

/*
 * Check whether the ARGV-element is a long option.
 *
 * If there's a long option "fubar" and the ARGV-element is "-fu", consider
 * that an abbreviation of the long option, just like "--fu", and not "-f" with
 * arg "u".
 *
 * This distinction seems to be the most useful approach.
 *
 */
static int check_long_opt(int argc, char *const *argv, const char *optstring,
		const struct option *longopts, int *longind,
		int print_errors, struct custom_getopt_data *d)
{
	char *nameend;
	const struct option *p;
	const struct option *pfound = NULL;
	int exact = 0;
	int ambig = 0;
	int indfound = -1;
	int option_index;

	for (nameend = d->nextchar; *nameend && *nameend != '='; nameend++)
		/* Do nothing.  */ ;

	/* Test all long options for either exact match or abbreviated matches */
	for (p = longopts, option_index = 0; p->name; p++, option_index++)
		if (!strncmp(p->name, d->nextchar, nameend - d->nextchar)) {
			if ((unsigned int) (nameend - d->nextchar)
					== (unsigned int) strlen(p->name)) {
				/* Exact match found.  */
				pfound = p;
				indfound = option_index;
				exact = 1;
				break;
			} else if (pfound == NULL) {
				/* First nonexact match found.  */
				pfound = p;
				indfound = option_index;
			} else if (pfound->has_arg != p->has_arg
					|| pfound->flag != p->flag
					|| pfound->val != p->val)
				/* Second or later nonexact match found.  */
				ambig = 1;
		}
	if (ambig && !exact) {
		if (print_errors) {
			fprintf(stderr,
				"%s: option `%s' is ambiguous\n",
				argv[0], argv[d->custom_optind]);
		}
		d->nextchar += strlen(d->nextchar);
		d->custom_optind++;
		d->custom_optopt = 0;
		return '?';
	}
	if (pfound) {
		option_index = indfound;
		d->custom_optind++;
		if (*nameend) {
			if (pfound->has_arg != no_argument)
				d->custom_optarg = nameend + 1;
			else {
				if (print_errors) {
					if (argv[d->custom_optind - 1][1] == '-') {
						/* --option */
						fprintf(stderr, "%s: option `--%s' doesn't allow an argument\n",
							argv[0], pfound->name);
					} else {
						/* +option or -option */
						fprintf(stderr, "%s: option `%c%s' doesn't allow an argument\n",
							argv[0], argv[d->custom_optind - 1][0], pfound->name);
					}

				}
				d->nextchar += strlen(d->nextchar);
				d->custom_optopt = pfound->val;
				return '?';
			}
		} else if (pfound->has_arg == required_argument) {
			if (d->custom_optind < argc)
				d->custom_optarg = argv[d->custom_optind++];
			else {
				if (print_errors) {
					fprintf(stderr,
						"%s: option `%s' requires an argument\n",
						argv[0],
						argv[d->custom_optind - 1]);
				}
				d->nextchar += strlen(d->nextchar);
				d->custom_optopt = pfound->val;
				return optstring[0] == ':' ? ':' : '?';
			}
		}
		d->nextchar += strlen(d->nextchar);
		if (longind != NULL)
			*longind = option_index;
		if (pfound->flag) {
			*(pfound->flag) = pfound->val;
			return 0;
		}
		return pfound->val;
	}
	/*
	 * Can't find it as a long option.  If this is not getopt_long_only, or
	 * the option starts with '--' or is not a valid short option, then
	 * it's an error.  Otherwise interpret it as a short option.
	 */
	if (print_errors) {
		if (argv[d->custom_optind][1] == '-') {
			/* --option */
			fprintf(stderr,
				"%s: unrecognized option `--%s'\n",
				argv[0], d->nextchar);
		} else {
			/* +option or -option */
			fprintf(stderr,
				"%s: unrecognized option `%c%s'\n",
				argv[0], argv[d->custom_optind][0],
				d->nextchar);
		}
	}
	d->nextchar = (char *) "";
	d->custom_optind++;
	d->custom_optopt = 0;
	return '?';
}

static int check_short_opt(int argc, char *const *argv, const char *optstring,
		int print_errors, struct custom_getopt_data *d)
{
	char c = *d->nextchar++;
	const char *temp = strchr(optstring, c);

	/* Increment `custom_optind' when we start to process its last character.  */
	if (*d->nextchar == '\0')
		++d->custom_optind;
	if (!temp || c == ':') {
		if (print_errors)
			fprintf(stderr, "%s: invalid option -- %c\n", argv[0], c);

		d->custom_optopt = c;
		return '?';
	}
	if (temp[1] == ':') {
		if (temp[2] == ':') {
			/* This is an option that accepts an argument optionally.  */
			if (*d->nextchar != '\0') {
				d->custom_optarg = d->nextchar;
				d->custom_optind++;
			} else
				d->custom_optarg = NULL;
			d->nextchar = NULL;
		} else {
			/* This is an option that requires an argument.  */
			if (*d->nextchar != '\0') {
				d->custom_optarg = d->nextchar;
				/*
				 * If we end this ARGV-element by taking the
				 * rest as an arg, we must advance to the next
				 * element now.
				 */
				d->custom_optind++;
			} else if (d->custom_optind == argc) {
				if (print_errors) {
					fprintf(stderr,
						"%s: option requires an argument -- %c\n",
						argv[0], c);
				}
				d->custom_optopt = c;
				if (optstring[0] == ':')
					c = ':';
				else
					c = '?';
			} else
				/*
				 * We already incremented `custom_optind' once;
				 * increment it again when taking next ARGV-elt
				 * as argument.
				 */
				d->custom_optarg = argv[d->custom_optind++];
			d->nextchar = NULL;
		}
	}
	return c;
}

/*
 * Scan elements of ARGV for option characters given in OPTSTRING.
 *
 * If an element of ARGV starts with '-', and is not exactly "-" or "--",
 * then it is an option element.  The characters of this element
 * (aside from the initial '-') are option characters.  If `getopt'
 * is called repeatedly, it returns successively each of the option characters
 * from each of the option elements.
 *
 * If `getopt' finds another option character, it returns that character,
 * updating `custom_optind' and `nextchar' so that the next call to `getopt' can
 * resume the scan with the following option character or ARGV-element.
 *
 * If there are no more option characters, `getopt' returns -1.
 * Then `custom_optind' is the index in ARGV of the first ARGV-element
 * that is not an option.  (The ARGV-elements have been permuted
 * so that those that are not options now come last.)
 *
 * OPTSTRING is a string containing the legitimate option characters.
 * If an option character is seen that is not listed in OPTSTRING,
 * return '?' after printing an error message.  If you set `custom_opterr' to
 * zero, the error message is suppressed but we still return '?'.
 *
 * If a char in OPTSTRING is followed by a colon, that means it wants an arg,
 * so the following text in the same ARGV-element, or the text of the following
 * ARGV-element, is returned in `custom_optarg'.  Two colons mean an option that
 * wants an optional arg; if there is text in the current ARGV-element,
 * it is returned in `custom_optarg', otherwise `custom_optarg' is set to zero.
 *
 * If OPTSTRING starts with `-' or `+', it requests different methods of
 * handling the non-option ARGV-elements.
 * See the comments about RETURN_IN_ORDER and REQUIRE_ORDER, above.
 *
 * Long-named options begin with `--' instead of `-'.
 * Their names may be abbreviated as long as the abbreviation is unique
 * or is an exact match for some defined option.  If they have an
 * argument, it follows the option name in the same ARGV-element, separated
 * from the option name by a `=', or else the in next ARGV-element.
 * When `getopt' finds a long-named option, it returns 0 if that option's
 * `flag' field is nonzero, the value of the option's `val' field
 * if the `flag' field is zero.
 *
 * The elements of ARGV aren't really const, because we permute them.
 * But we pretend they're const in the prototype to be compatible
 * with other systems.
 *
 * LONGOPTS is a vector of `struct option' terminated by an
 * element containing a name which is zero.
 *
 * LONGIND returns the index in LONGOPT of the long-named option found.
 * It is only valid when a long-named option has been found by the most
 * recent call.
 *
 * Return the option character from OPTS just read.  Return -1 when there are
 * no more options.  For unrecognized options, or options missing arguments,
 * `custom_optopt' is set to the option letter, and '?' is returned.
 *
 * The OPTS string is a list of characters which are recognized option letters,
 * optionally followed by colons, specifying that that letter takes an
 * argument, to be placed in `custom_optarg'.
 *
 * If a letter in OPTS is followed by two colons, its argument is optional.
 * This behavior is specific to the GNU `getopt'.
 *
 * The argument `--' causes premature termination of argument scanning,
 * explicitly telling `getopt' that there are no more options.  If OPTS begins
 * with `--', then non-option arguments are treated as arguments to the option
 * '\0'.  This behavior is specific to the GNU `getopt'.
 */

static int getopt_internal_r(int argc, char *const *argv, const char *optstring,
		const struct option *longopts, int *longind,
		struct custom_getopt_data *d)
{
	int ret, print_errors = d->custom_opterr;

	if (optstring[0] == ':')
		print_errors = 0;
	if (argc < 1)
		return -1;
	d->custom_optarg = NULL;

	/* 
	 * This is a big difference with GNU getopt, since optind == 0
	 * means initialization while here 1 means first call.
	 */
	if (d->custom_optind == 0 || !d->initialized) {
		if (d->custom_optind == 0)
			d->custom_optind = 1;	/* Don't scan ARGV[0], the program name.  */
		custom_getopt_initialize(d);
	}
	if (d->nextchar == NULL || *d->nextchar == '\0') {
		ret = shuffle_argv(argc, argv, longopts, d);
		if (ret)
			return ret;
	}
	if (longopts && (argv[d->custom_optind][1] == '-' ))
		return check_long_opt(argc, argv, optstring, longopts,
			longind, print_errors, d);
	return check_short_opt(argc, argv, optstring, print_errors, d);
}

static int custom_getopt_internal(int argc, char *const *argv, const char *optstring,
	const struct option *longopts, int *longind)
{
	int result;
	/* Keep a global copy of all internal members of d */
	static struct custom_getopt_data d;

	d.custom_optind = custom_optind;
	d.custom_opterr = custom_opterr;
	result = getopt_internal_r(argc, argv, optstring, longopts,
		longind, &d);
	custom_optind = d.custom_optind;
	custom_optarg = d.custom_optarg;
	custom_optopt = d.custom_optopt;
	return result;
}

static int custom_getopt_long (int argc, char *const *argv, const char *options,
	const struct option *long_options, int *opt_index)
{
	return custom_getopt_internal(argc, argv, options, long_options,
		opt_index);
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see cmdline_parser_params.check_ambiguity
 * @param override @see cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;
  FIX_UNUSED (field);

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  FIX_UNUSED (default_value);
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_FLAG:
    *((int *)field) = !*((int *)field);
    break;
  case ARG_INT:
    if (val) *((int *)field) = strtol (val, &stop_char, 0);
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };

  /* check numeric conversion */
  switch(arg_type) {
  case ARG_INT:
    if (val && !(stop_char && *stop_char == '\0')) {
      fprintf(stderr, "%s: invalid numeric value: %s\n", package_name, val);
      return 1; /* failure */
    }
    break;
  default:
    ;
  };

  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
  case ARG_FLAG:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}

/**
 * @brief store information about a multiple option in a temporary list
 * @param list where to (temporarily) store multiple options
 */
static
int update_multiple_arg_temp(struct generic_list **list,
               unsigned int *prev_given, const char *val,
               const char *possible_values[], const char *default_value,
               cmdline_parser_arg_type arg_type,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  /* store single arguments */
  char *multi_token;
  const char *multi_next;

  if (arg_type == ARG_NO) {
    (*prev_given)++;
    return 0; /* OK */
  }

  multi_token = get_multiple_arg_token(val);
  multi_next = get_multiple_arg_token_next (val);

  while (1)
    {
      add_node (list);
      if (update_arg((void *)&((*list)->arg), &((*list)->orig), 0,
          prev_given, multi_token, possible_values, default_value, 
          arg_type, 0, 1, 1, 1, long_opt, short_opt, additional_error)) {
        if (multi_token) free(multi_token);
        return 1; /* failure */
      }

      if (multi_next)
        {
          multi_token = get_multiple_arg_token(multi_next);
          multi_next = get_multiple_arg_token_next (multi_next);
        }
      else
        break;
    }

  return 0; /* OK */
}

/**
 * @brief free the passed list (including possible string argument)
 */
static
void free_list(struct generic_list *list, short string_arg)
{
  if (list) {
    struct generic_list *tmp;
    while (list)
      {
        tmp = list;
        if (string_arg && list->arg.string_arg)
          free (list->arg.string_arg);
        if (list->orig)
          free (list->orig);
        list = list->next;
        free (tmp);
      }
  }
}

/**
 * @brief updates a multiple option starting from the passed list
 */
static
void update_multiple_arg(void *field, char ***orig_field,
               unsigned int field_given, unsigned int prev_given, union generic_value *default_value,
               cmdline_parser_arg_type arg_type,
               struct generic_list *list)
{
  int i;
  struct generic_list *tmp;

  if (prev_given && list) {
    *orig_field = (char **) realloc (*orig_field, (field_given + prev_given) * sizeof (char *));

    switch(arg_type) {
    case ARG_INT:
      *((int **)field) = (int *)realloc (*((int **)field), (field_given + prev_given) * sizeof (int)); break;
    case ARG_STRING:
      *((char ***)field) = (char **)realloc (*((char ***)field), (field_given + prev_given) * sizeof (char *)); break;
    default:
      break;
    };
    
    for (i = (prev_given - 1); i >= 0; --i)
      {
        tmp = list;
        
        switch(arg_type) {
        case ARG_INT:
          (*((int **)field))[i + field_given] = tmp->arg.int_arg; break;
        case ARG_STRING:
          (*((char ***)field))[i + field_given] = tmp->arg.string_arg; break;
        default:
          break;
        }        
        (*orig_field) [i + field_given] = list->orig;
        list = list->next;
        free (tmp);
      }
  } else { /* set the default value */
    if (default_value && ! field_given) {
      switch(arg_type) {
      case ARG_INT:
        if (! *((int **)field)) {
          *((int **)field) = (int *)malloc (sizeof (int));
          (*((int **)field))[0] = default_value->int_arg; 
        }
        break;
      case ARG_STRING:
        if (! *((char ***)field)) {
          *((char ***)field) = (char **)malloc (sizeof (char *));
          (*((char ***)field))[0] = gengetopt_strdup(default_value->string_arg);
        }
        break;
      default: break;
      }
      if (!(*orig_field)) {
        *orig_field = (char **) malloc (sizeof (char *));
        (*orig_field)[0] = 0;
      }
    }
  }
}

int
cmdline_parser_internal (
  int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  struct generic_list * cv_certificate_list = NULL;
  int error_occurred = 0;
  struct gengetopt_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;

  char *optarg;
  int optind;
  int opterr;
  int optopt;
  
  package_name = argv[0];
  
  override = params->override;
  initialize = params->initialize;
  check_required = params->check_required;
  check_ambiguity = params->check_ambiguity;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "reader",	1, NULL, 'r' },
        { "verbose",	0, NULL, 'v' },
        { "pin",	2, NULL, 'p' },
        { "puk",	2, NULL, 'u' },
        { "can",	2, NULL, 'c' },
        { "mrz",	2, NULL, 'm' },
        { "env",	0, NULL, 0 },
        { "new-pin",	2, NULL, 'N' },
        { "resume",	0, NULL, 'R' },
        { "unblock",	0, NULL, 'U' },
        { "cv-certificate",	1, NULL, 'C' },
        { "cert-desc",	1, NULL, 0 },
        { "chat",	1, NULL, 0 },
        { "auxiliary-data",	1, NULL, 'A' },
        { "private-key",	1, NULL, 'P' },
        { "cvc-dir",	1, NULL, 0 },
        { "x509-dir",	1, NULL, 0 },
        { "disable-ta-checks",	0, NULL, 0 },
        { "disable-ca-checks",	0, NULL, 0 },
        { "read-dg1",	0, NULL, 0 },
        { "read-dg2",	0, NULL, 0 },
        { "read-dg3",	0, NULL, 0 },
        { "read-dg4",	0, NULL, 0 },
        { "read-dg5",	0, NULL, 0 },
        { "read-dg6",	0, NULL, 0 },
        { "read-dg7",	0, NULL, 0 },
        { "read-dg8",	0, NULL, 0 },
        { "read-dg9",	0, NULL, 0 },
        { "read-dg10",	0, NULL, 0 },
        { "read-dg11",	0, NULL, 0 },
        { "read-dg12",	0, NULL, 0 },
        { "read-dg13",	0, NULL, 0 },
        { "read-dg14",	0, NULL, 0 },
        { "read-dg15",	0, NULL, 0 },
        { "read-dg16",	0, NULL, 0 },
        { "read-dg17",	0, NULL, 0 },
        { "read-dg18",	0, NULL, 0 },
        { "read-dg19",	0, NULL, 0 },
        { "read-dg20",	0, NULL, 0 },
        { "read-dg21",	0, NULL, 0 },
        { "write-dg17",	1, NULL, 0 },
        { "write-dg18",	1, NULL, 0 },
        { "write-dg19",	1, NULL, 0 },
        { "write-dg20",	1, NULL, 0 },
        { "write-dg21",	1, NULL, 0 },
        { "verify-validity",	1, NULL, 0 },
        { "older-than",	1, NULL, 0 },
        { "verify-community",	1, NULL, 0 },
        { "break",	0, NULL, 'b' },
        { "translate",	1, NULL, 't' },
        { "tr-03110v201",	0, NULL, 0 },
        { "disable-all-checks",	0, NULL, 0 },
        { 0,  0, 0, 0 }
      };

      custom_optarg = optarg;
      custom_optind = optind;
      custom_opterr = opterr;
      custom_optopt = optopt;

      c = custom_getopt_long (argc, argv, "hVr:vp::u::c::m::N::RUC:A:P:bt:", long_options, &option_index);

      optarg = custom_optarg;
      optind = custom_optind;
      opterr = custom_opterr;
      optopt = custom_optopt;

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cmdline_parser_print_help ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          cmdline_parser_print_version ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'r':	/* Number of the PC/SC reader to use (-1 for autodetect).  */
        
        
          if (update_arg( (void *)&(args_info->reader_arg), 
               &(args_info->reader_orig), &(args_info->reader_given),
              &(local_args_info.reader_given), optarg, 0, "-1", ARG_INT,
              check_ambiguity, override, 0, 0,
              "reader", 'r',
              additional_error))
            goto failure;
        
          break;
        case 'v':	/* Use (several times) to be more verbose.  */
        
          local_args_info.verbose_given++;
        
          break;
        case 'p':	/* Run PACE with (transport) eID-PIN.  */
        
        
          if (update_arg( (void *)&(args_info->pin_arg), 
               &(args_info->pin_orig), &(args_info->pin_given),
              &(local_args_info.pin_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "pin", 'p',
              additional_error))
            goto failure;
        
          break;
        case 'u':	/* Run PACE with PUK.  */
        
        
          if (update_arg( (void *)&(args_info->puk_arg), 
               &(args_info->puk_orig), &(args_info->puk_given),
              &(local_args_info.puk_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "puk", 'u',
              additional_error))
            goto failure;
        
          break;
        case 'c':	/* Run PACE with CAN.  */
        
        
          if (update_arg( (void *)&(args_info->can_arg), 
               &(args_info->can_orig), &(args_info->can_given),
              &(local_args_info.can_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "can", 'c',
              additional_error))
            goto failure;
        
          break;
        case 'm':	/* Run PACE with MRZ (insert MRZ without newlines).  */
        
        
          if (update_arg( (void *)&(args_info->mrz_arg), 
               &(args_info->mrz_orig), &(args_info->mrz_given),
              &(local_args_info.mrz_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "mrz", 'm',
              additional_error))
            goto failure;
        
          break;
        case 'N':	/* Install a new PIN.  */
        
        
          if (update_arg( (void *)&(args_info->new_pin_arg), 
               &(args_info->new_pin_orig), &(args_info->new_pin_given),
              &(local_args_info.new_pin_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "new-pin", 'N',
              additional_error))
            goto failure;
        
          break;
        case 'R':	/* Resume eID-PIN (uses CAN to activate last retry).  */
        
        
          if (update_arg((void *)&(args_info->resume_flag), 0, &(args_info->resume_given),
              &(local_args_info.resume_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "resume", 'R',
              additional_error))
            goto failure;
        
          break;
        case 'U':	/* Unblock PIN (uses PUK to activate three more retries).  */
        
        
          if (update_arg((void *)&(args_info->unblock_flag), 0, &(args_info->unblock_given),
              &(local_args_info.unblock_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "unblock", 'U',
              additional_error))
            goto failure;
        
          break;
        case 'C':	/* Card Verifiable Certificate to create a certificate chain. Can be used multiple times (order is important)..  */
        
          if (update_multiple_arg_temp(&cv_certificate_list, 
              &(local_args_info.cv_certificate_given), optarg, 0, 0, ARG_STRING,
              "cv-certificate", 'C',
              additional_error))
            goto failure;
        
          break;
        case 'A':	/* Terminal's auxiliary data (default is determined by verification of validity, age and community ID)..  */
        
        
          if (update_arg( (void *)&(args_info->auxiliary_data_arg), 
               &(args_info->auxiliary_data_orig), &(args_info->auxiliary_data_given),
              &(local_args_info.auxiliary_data_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "auxiliary-data", 'A',
              additional_error))
            goto failure;
        
          break;
        case 'P':	/* Terminal's private key.  */
        
        
          if (update_arg( (void *)&(args_info->private_key_arg), 
               &(args_info->private_key_orig), &(args_info->private_key_given),
              &(local_args_info.private_key_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "private-key", 'P',
              additional_error))
            goto failure;
        
          break;
        case 'b':	/* Brute force PIN, CAN or PUK. Use together with -p, -a or -u.  */
        
        
          if (update_arg((void *)&(args_info->break_flag), 0, &(args_info->break_given),
              &(local_args_info.break_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "break", 'b',
              additional_error))
            goto failure;
        
          break;
        case 't':	/* File with APDUs of HEX_STRINGs to send through the secure channel.  */
        
        
          if (update_arg( (void *)&(args_info->translate_arg), 
               &(args_info->translate_orig), &(args_info->translate_given),
              &(local_args_info.translate_given), optarg, 0, "stdin", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "translate", 't',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
          /* Whether to use environment variables PIN, PUK, CAN, MRZ and NEWPIN. You may want to clean your environment before enabling this..  */
          if (strcmp (long_options[option_index].name, "env") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->env_flag), 0, &(args_info->env_given),
                &(local_args_info.env_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "env", '-',
                additional_error))
              goto failure;
          
          }
          /* Certificate description to show for Terminal Authentication.  */
          else if (strcmp (long_options[option_index].name, "cert-desc") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->cert_desc_arg), 
                 &(args_info->cert_desc_orig), &(args_info->cert_desc_given),
                &(local_args_info.cert_desc_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "cert-desc", '-',
                additional_error))
              goto failure;
          
          }
          /* Card holder authorization template to use (default is terminal's CHAT). Use 7F4C0E060904007F000703010203530103 to trigger EAC on the CAT-C (Komfortleser)..  */
          else if (strcmp (long_options[option_index].name, "chat") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->chat_arg), 
                 &(args_info->chat_orig), &(args_info->chat_given),
                &(local_args_info.chat_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "chat", '-',
                additional_error))
              goto failure;
          
          }
          /* Where to look for the CVCA's certificate.  */
          else if (strcmp (long_options[option_index].name, "cvc-dir") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->cvc_dir_arg), 
                 &(args_info->cvc_dir_orig), &(args_info->cvc_dir_given),
                &(local_args_info.cvc_dir_given), optarg, 0, "/home/fm/.local/etc/eac/cvc", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "cvc-dir", '-',
                additional_error))
              goto failure;
          
          }
          /* Where to look for the CSCA's certificate.  */
          else if (strcmp (long_options[option_index].name, "x509-dir") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->x509_dir_arg), 
                 &(args_info->x509_dir_orig), &(args_info->x509_dir_given),
                &(local_args_info.x509_dir_given), optarg, 0, "/home/fm/.local/etc/eac/x509", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "x509-dir", '-',
                additional_error))
              goto failure;
          
          }
          /* Disable checking the validity period of CV certifcates.  */
          else if (strcmp (long_options[option_index].name, "disable-ta-checks") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->disable_ta_checks_flag), 0, &(args_info->disable_ta_checks_given),
                &(local_args_info.disable_ta_checks_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "disable-ta-checks", '-',
                additional_error))
              goto failure;
          
          }
          /* Disable passive authentication.  */
          else if (strcmp (long_options[option_index].name, "disable-ca-checks") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->disable_ca_checks_flag), 0, &(args_info->disable_ca_checks_given),
                &(local_args_info.disable_ca_checks_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "disable-ca-checks", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 1   (Document Type).  */
          else if (strcmp (long_options[option_index].name, "read-dg1") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg1_flag), 0, &(args_info->read_dg1_given),
                &(local_args_info.read_dg1_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg1", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 2   (Issuing State).  */
          else if (strcmp (long_options[option_index].name, "read-dg2") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg2_flag), 0, &(args_info->read_dg2_given),
                &(local_args_info.read_dg2_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg2", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 3   (Date of Expiry).  */
          else if (strcmp (long_options[option_index].name, "read-dg3") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg3_flag), 0, &(args_info->read_dg3_given),
                &(local_args_info.read_dg3_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg3", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 4   (Given Names).  */
          else if (strcmp (long_options[option_index].name, "read-dg4") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg4_flag), 0, &(args_info->read_dg4_given),
                &(local_args_info.read_dg4_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg4", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 5   (Family Names).  */
          else if (strcmp (long_options[option_index].name, "read-dg5") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg5_flag), 0, &(args_info->read_dg5_given),
                &(local_args_info.read_dg5_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg5", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 6   (Religious/Artistic Name).  */
          else if (strcmp (long_options[option_index].name, "read-dg6") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg6_flag), 0, &(args_info->read_dg6_given),
                &(local_args_info.read_dg6_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg6", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 7   (Academic Title).  */
          else if (strcmp (long_options[option_index].name, "read-dg7") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg7_flag), 0, &(args_info->read_dg7_given),
                &(local_args_info.read_dg7_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg7", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 8   (Date of Birth).  */
          else if (strcmp (long_options[option_index].name, "read-dg8") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg8_flag), 0, &(args_info->read_dg8_given),
                &(local_args_info.read_dg8_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg8", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 9   (Place of Birth).  */
          else if (strcmp (long_options[option_index].name, "read-dg9") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg9_flag), 0, &(args_info->read_dg9_given),
                &(local_args_info.read_dg9_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg9", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 10  (Nationality).  */
          else if (strcmp (long_options[option_index].name, "read-dg10") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg10_flag), 0, &(args_info->read_dg10_given),
                &(local_args_info.read_dg10_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg10", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 11  (Sex).  */
          else if (strcmp (long_options[option_index].name, "read-dg11") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg11_flag), 0, &(args_info->read_dg11_given),
                &(local_args_info.read_dg11_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg11", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 12  (Optional Data).  */
          else if (strcmp (long_options[option_index].name, "read-dg12") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg12_flag), 0, &(args_info->read_dg12_given),
                &(local_args_info.read_dg12_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg12", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 13  (Birth Name).  */
          else if (strcmp (long_options[option_index].name, "read-dg13") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg13_flag), 0, &(args_info->read_dg13_given),
                &(local_args_info.read_dg13_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg13", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 14.  */
          else if (strcmp (long_options[option_index].name, "read-dg14") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg14_flag), 0, &(args_info->read_dg14_given),
                &(local_args_info.read_dg14_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg14", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 15.  */
          else if (strcmp (long_options[option_index].name, "read-dg15") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg15_flag), 0, &(args_info->read_dg15_given),
                &(local_args_info.read_dg15_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg15", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 16.  */
          else if (strcmp (long_options[option_index].name, "read-dg16") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg16_flag), 0, &(args_info->read_dg16_given),
                &(local_args_info.read_dg16_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg16", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 17  (Normal Place of Residence).  */
          else if (strcmp (long_options[option_index].name, "read-dg17") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg17_flag), 0, &(args_info->read_dg17_given),
                &(local_args_info.read_dg17_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg17", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 18  (Community ID).  */
          else if (strcmp (long_options[option_index].name, "read-dg18") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg18_flag), 0, &(args_info->read_dg18_given),
                &(local_args_info.read_dg18_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg18", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 19  (Residence Permit I).  */
          else if (strcmp (long_options[option_index].name, "read-dg19") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg19_flag), 0, &(args_info->read_dg19_given),
                &(local_args_info.read_dg19_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg19", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 20  (Residence Permit II).  */
          else if (strcmp (long_options[option_index].name, "read-dg20") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg20_flag), 0, &(args_info->read_dg20_given),
                &(local_args_info.read_dg20_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg20", '-',
                additional_error))
              goto failure;
          
          }
          /* Read DG 21  (Optional Data).  */
          else if (strcmp (long_options[option_index].name, "read-dg21") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg21_flag), 0, &(args_info->read_dg21_given),
                &(local_args_info.read_dg21_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg21", '-',
                additional_error))
              goto failure;
          
          }
          /* Write DG 17 (Normal Place of Residence).  */
          else if (strcmp (long_options[option_index].name, "write-dg17") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->write_dg17_arg), 
                 &(args_info->write_dg17_orig), &(args_info->write_dg17_given),
                &(local_args_info.write_dg17_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "write-dg17", '-',
                additional_error))
              goto failure;
          
          }
          /* Write DG 18 (Community ID).  */
          else if (strcmp (long_options[option_index].name, "write-dg18") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->write_dg18_arg), 
                 &(args_info->write_dg18_orig), &(args_info->write_dg18_given),
                &(local_args_info.write_dg18_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "write-dg18", '-',
                additional_error))
              goto failure;
          
          }
          /* Write DG 19 (Residence Permit I).  */
          else if (strcmp (long_options[option_index].name, "write-dg19") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->write_dg19_arg), 
                 &(args_info->write_dg19_orig), &(args_info->write_dg19_given),
                &(local_args_info.write_dg19_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "write-dg19", '-',
                additional_error))
              goto failure;
          
          }
          /* Write DG 20 (Residence Permit II).  */
          else if (strcmp (long_options[option_index].name, "write-dg20") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->write_dg20_arg), 
                 &(args_info->write_dg20_orig), &(args_info->write_dg20_given),
                &(local_args_info.write_dg20_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "write-dg20", '-',
                additional_error))
              goto failure;
          
          }
          /* Write DG 21 (Optional Data).  */
          else if (strcmp (long_options[option_index].name, "write-dg21") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->write_dg21_arg), 
                 &(args_info->write_dg21_orig), &(args_info->write_dg21_given),
                &(local_args_info.write_dg21_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "write-dg21", '-',
                additional_error))
              goto failure;
          
          }
          /* Verify chip's validity with a reference date.  */
          else if (strcmp (long_options[option_index].name, "verify-validity") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->verify_validity_arg), 
                 &(args_info->verify_validity_orig), &(args_info->verify_validity_given),
                &(local_args_info.verify_validity_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "verify-validity", '-',
                additional_error))
              goto failure;
          
          }
          /* Verify age with a reference date.  */
          else if (strcmp (long_options[option_index].name, "older-than") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->older_than_arg), 
                 &(args_info->older_than_orig), &(args_info->older_than_given),
                &(local_args_info.older_than_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "older-than", '-',
                additional_error))
              goto failure;
          
          }
          /* Verify community ID with a reference ID.  */
          else if (strcmp (long_options[option_index].name, "verify-community") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->verify_community_arg), 
                 &(args_info->verify_community_orig), &(args_info->verify_community_given),
                &(local_args_info.verify_community_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "verify-community", '-',
                additional_error))
              goto failure;
          
          }
          /* Force compliance to BSI TR-03110 version 2.01.  */
          else if (strcmp (long_options[option_index].name, "tr-03110v201") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->tr_03110v201_flag), 0, &(args_info->tr_03110v201_given),
                &(local_args_info.tr_03110v201_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "tr-03110v201", '-',
                additional_error))
              goto failure;
          
          }
          /* Disable all checking of fly-by-data.  */
          else if (strcmp (long_options[option_index].name, "disable-all-checks") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->disable_all_checks_flag), 0, &(args_info->disable_all_checks_given),
                &(local_args_info.disable_all_checks_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "disable-all-checks", '-',
                additional_error))
              goto failure;
          
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */


  update_multiple_arg((void *)&(args_info->cv_certificate_arg),
    &(args_info->cv_certificate_orig), args_info->cv_certificate_given,
    local_args_info.cv_certificate_given, 0,
    ARG_STRING, cv_certificate_list);

  args_info->verbose_given += local_args_info.verbose_given;
  local_args_info.verbose_given = 0;
  args_info->cv_certificate_given += local_args_info.cv_certificate_given;
  local_args_info.cv_certificate_given = 0;
  
  if (check_required)
    {
      error_occurred += cmdline_parser_required2 (args_info, argv[0], additional_error);
    }

  cmdline_parser_release (&local_args_info);

  if ( error_occurred )
    return (EXIT_FAILURE);

  return 0;

failure:
  free_list (cv_certificate_list, 1 );
  
  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
